theory question_85_0
imports Main

begin
typedecl entity
typedecl event

consts
  Vendor :: "entity ⇒ bool"
  Seller :: "entity ⇒ bool"
  Flower :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  Selling :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Vendor is a seller *)
axiomatization where
  explanation_1: "∀x. Vendor x ⟶ Seller x"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Sidewalk x ∧ FlowerCart y ∧ Vendor e ∧ On y e ∧ On x e"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y e. Flower x ∧ Seller y ∧ Sidewalk e ∧ On x e ∧ On y e ∧ Selling e ∧ Agent e y ∧ Patient e x"
proof -
  from asm have "Vendor e" by blast
  then have "Seller e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
