theory question_21_0
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  SnowyDay :: "event ⇒ bool"
  DownTheStreet :: "event ⇒ bool"
  Winter :: "event ⇒ bool"
  NorthFaceJacket :: "entity ⇒ bool"
  Walks :: "event ⇒ bool"
  ThroughTheCrowdedStreets :: "event ⇒ bool"
  Past :: "event ⇒ entity ⇒ bool"
  GarbageTruck :: "entity ⇒ bool"

(* Explanation 1: Since the man is walking on a snowy day down a street, it is likely winter. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ SnowyDay e ∧ DownTheStreet e ⟶ Winter e"

theorem hypothesis:
  (* Premise: on a snowy day a man with a north face jacket walks through the crowded streets past a garbage truck *)
  assumes asm: "Man x ∧ NorthFaceJacket x ∧ Walks e ∧ SnowyDay e ∧ ThroughTheCrowdedStreets e ∧ Past e x GarbageTruck"
  (* Hypothesis: A man walks down the street in winter. *)
  shows "∃x e. Man x ∧ Walks e ∧ DownTheStreet e ∧ Winter e"
proof -
  from asm have "Man x ∧ SnowyDay e" by blast
  then have "Winter e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
