colnames(Pre_exp_PT)
colnames(website_exp_PT)
new_df <- merge(x = Pre_exp_PT, y = website_exp_PT, by = "Participant_ID", all = TRUE)
Integrated_exp_data <- merge(x = new_df, y = Post_exp_PT, by = "Participant_ID", all = TRUE)
colnames(Integrated_exp_data)
#integrated_data_round12 <- data.frame(a = 1:30, b = 31:34, c= 35:65)
#integrated_data_round12 <- integrated_data_round12 %>% relocate(b, .after = last_col())


write.xlsx(integrated_exp_data, file = "Integrated_exp_data.xlsx", sheetName = "Integrated_exp_data", append = FALSE)

model_1 <- 'satisf =~ s1 + s2 + s3 + s4 + s5  + s6 + s7
quality =~ q1+q2+q3+q4+q5+q6
control =~ c1+C2+C3+C4
underst =~u2+u4+u5
satisf ~ p1*citem+p2*cfriend+cgraph+p3*cig+p4*cfg'
fit <- sem(model_1, data=twq, ordered = names(twq[9:31]), std.lv=TRUE)
summary(fit)

#CFA, ordered, without satisfaction and comfort
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC2 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#PC2 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#Final CFA model: PC2, EOU7, PC4, EOU9, ITU4, EOU8 are removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC3 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#EOU6 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#PC5 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#ITU4 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#EOU9 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#PC3 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#without order categorical variables
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

#PC3 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#EOU5 is removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

#merging ITU and satisfaction
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m, data=Integrated_exp_data, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m1 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m1, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m2 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9'
fit <- cfa(m2, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m3 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m3, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m4 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5'
fit <- cfa(m4, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m5 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m5, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m6 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3 + EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5'
fit <- cfa(m6, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m7 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3 + EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5'
fit <- cfa(m7, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m8 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3 + EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC2 + PC3 + PC4 + PC5'
fit <- cfa(m8, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#merging ITU and satisfaction, PC2 removed
m9 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9'
fit <- cfa(m9, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

#dummy contrasts for exp. conditions
onlyMT_v_others <- c(-2/3, 1/3, 1/3)
MTwithEdit_v_manual <- c(0, 1/2, -1/2)
contrasts(Integrated_exp_data$Exp_conditions) <- cbind(onlyMT_v_others, MTwithEdit_v_manual)

aov_m1 <- aov((PC1+PC2+PC3+PC4)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m1)

aov_m2 <- aov((EOU1+EOU2+EOU3+EOU4+EOU5+EOU6+EOU7+EOU8+EOU9)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m2)

aov_m3 <- aov((PCO1 + PCO2 + PCO3)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m3)

aov_m4 <- aov((SE1 + SE2 + SE3)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m4)

aov_m5 <- aov((PS1 + PS2 + PS3)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m5)

aov_m6 <- aov((ITU1 + ITU2 + ITU3 + ITU4)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m6)

aov_m7 <- aov((ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3)~Exp_conditions, data=Integrated_exp_data)
summary.lm(aov_m7)

#reruning CFA by removing "ease of use" factor
m2 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5'
fit <- cfa(m2, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m3 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5'
fit <- cfa(m3, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m4 <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4'
fit <- cfa(m4, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m5 <- 'intention =~ ITU1 + ITU2 + ITU3 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4'
fit <- cfa(m5, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m6 <- 'intention =~ ITU1 + ITU2 + ITU3 + PS1 + PS2 + PS3
effectiveness =~ SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4'
fit <- cfa(m6, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

m7 <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE2 + SE3
satisfaction =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4'
fit <- cfa(m7, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

## mimic model and Structure equation modeling
#movie$divmedium <- ifelse(movie$diversification == "medium", 1, 0)

#Integrated_exp_data$Exp_conditions <- as.factor(Integrated_exp_data$Exp_conditions)

#making MT_with_edit as baseline and dummies of other conditions
Integrated_exp_data$manual <- ifelse(Integrated_exp_data$Exp_conditions== "manual_translation", 1, 0)
Integrated_exp_data$only_MT <- ifelse(Integrated_exp_data$Exp_conditions == "only_MT", 1, 0)

#Integrated_exp_data_Ananya$man_trans <- as.numeric(Integrated_exp_data_Ananya$Exp_conditions== "manual_translation")
#Integrated_exp_data_Ananya$MT_only <- as.numeric(Integrated_exp_data_Ananya$Exp_conditions == "only_MT")


#PC2, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intn ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered categorical variables
#PC2, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intn ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC2, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
satisf ~ ps_man*manual + ps_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC2, PC3, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
effectiveness ~ se_man*manual + se_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC2, PC3, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
comfort ~ pco_man*manual + pco_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC2, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
control ~ pc_man*manual + pc_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC2, PC5, EOU6, EOU9, ITU4 are removed in the mimic model below
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
ease_of_use ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m1<- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU6 + EOU7 + EOU8 + EOU9
satisf ~ ps_man*manual + ps_onlyMT*only_MT'
fit <- sem(m1, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered categorical
m1<- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
satisf ~ ps_man*manual + ps_onlyMT*only_MT'
fit <- sem(m1, data=Integrated_exp_data_Ananya, ordered = names(Integrated_exp_data_Ananya[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered categorical
m2 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
effectiveness ~ se_man*manual + se_onlyMT*only_MT'
fit <- sem(m2, data=Integrated_exp_data_Ananya, ordered = names(Integrated_exp_data_Ananya[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m3 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
comfort ~ pco_man*manual + pco_onlyMT*only_MT'
fit <- sem(m3, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered categorical
m3 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
comfort ~ pco_man*manual + pco_onlyMT*only_MT'
fit <- sem(m3, data=Integrated_exp_data_Ananya, ordered = names(Integrated_exp_data_Ananya[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m4 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
control ~ pc_man*manual + pc_onlyMT*only_MT'
fit <- sem(m4, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered categorical
m4 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
control ~ pc_man*manual + pc_onlyMT*only_MT'
fit <- sem(m4, data=Integrated_exp_data_Ananya, ordered = names(Integrated_exp_data_Ananya[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m5 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
ease_of_use ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(m5, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#with ordered cate....
m5 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1  + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
ease_of_use ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(m5, data=Integrated_exp_data_Ananya, ordered = names(Integrated_exp_data_Ananya[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC3 is removed 
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8 + EOU9
intn ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#PC3 and then EOU5 is removed
#regression of intention to use
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
intn ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#satisfaction
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
satisf ~ ps_man*manual + ps_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m2 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
effectiveness ~ se_man*manual + se_onlyMT*only_MT'
fit <- sem(m2, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m3 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
comfort ~ pco_man*manual + pco_onlyMT*only_MT'
fit <- sem(m3, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m4 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
control ~ pc_man*manual + pc_onlyMT*only_MT'
fit <- sem(m4, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

m5 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
ease_of_use ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(m5, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#merging satisfaction and ITU
s_model <- 'intn_sat =~ ITU1 + ITU2 + ITU3 + ITU4 + PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
intn_sat ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#merging satisfaction and ease of use
m5 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
sat_eou =~ PS1 + PS2 + PS3 + EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
sat_eou ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(m5, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#merging system effectiveness and ease of use
m5 <- 'intn =~ ITU1 + ITU2 + ITU3 + ITU4
satisf =~ PS1 + PS2 + PS3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4 + PC5
se_eou =~ SE1 + SE2 + SE3 + EOU1 + EOU2 + EOU3 + EOU4 + EOU6 + EOU7 + EOU8 + EOU9
se_eou ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(m5, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#Final CFA model
#Final CFA model: PC2, EOU6, PC5, ITU4, EOU9, PC3, EOU5 are removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

mods <- modindices(fit, power = TRUE)
mods <- mods[grep("\\*", mods$decision),]
mods

#Final CFA model
#Final CFA model: PC2, EOU6, PC5, ITU4, EOU9, PC3, EOU5 are removed
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU7 + EOU8'
fit <- cfa(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#MIMIC model on trimmed CFA model PC2, EOU7, PC4, EOU9, EOU8 are removed
#intention to use
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU7 + EOU8
intention ~ ITU_man*manual + ITU_onlyMT*only_MT'
fit <- sem(m, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#MIMIC model for system effectiveness
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU7 + EOU8
effectiveness ~ SE_man*manual + SE_onlyMT*only_MT'
fit <- sem(m, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#MIMIC model for Perceived control
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU7 + EOU8
control ~ PC_man*manual + PC_onlyMT*only_MT'
fit <- sem(m, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#MIMIC model for Ease of use
m <- 'intention =~ ITU1 + ITU2 + ITU3 
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU7 + EOU8
ease_of_use ~ EOU_man*manual + EOU_onlyMT*only_MT'
fit <- sem(m, data=Integrated_exp_data_Ananya, std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#sem with causal oredered effect
m <- 'intention =~ ITU1 + ITU2 + ITU3 + ITU4
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC3 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intention ~ effectiveness + comfort + ease_of_use
effectiveness ~ comfort + ease_of_use  + SE_man*manual + SE_onlyMT*only_MT
comfort ~  ease_of_use  + control
ease_of_use ~ control + EOU_man*manual + EOU_onlyMT*only_MT
control ~ PC_man*manual + PC_onlyMT*only_MT'
fit <- sem(m, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

lavTestWald(fit, "ITU_man == 0; ITU_onlyMT == 0")
lavTestWald(fit, "SE_man == 0; SE_onlyMT == 0")
lavTestWald(fit, "PS_man == 0; PS_onlyMT == 0")
lavTestWald(fit, "PCO_man == 0; PCO_onlyMT == 0")
lavTestWald(fit, "PC_man == 0; PC_onlyMT == 0")
lavTestWald(fit, "EOU_man == 0; EOU_onlyMT == 0")

#final model with ease of use at the end
Integrated_exp_data$manual <- ifelse(Integrated_exp_data$Exp_conditions== "manual_translation", 1, 0)
Integrated_exp_data$only_MT <- ifelse(Integrated_exp_data$Exp_conditions == "only_MT", 1, 0)
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intn ~ effectiveness + satisf + comfort
effectiveness ~ satisf + comfort + se_man*manual + se_onlyMT*only_MT
satisf ~  ease_of_use 
comfort ~ ease_of_use 
control ~ ease_of_use + pc_man*manual + pc_onlyMT*only_MT
ease_of_use ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#sem with causal order with perceived control at the end
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intn ~ effectiveness + satisf + comfort + ease_of_use + control + 
effectiveness ~ satisf + comfort + se_man*manual + se_onlyMT*only_MT
satisf ~ ease_of_use 
ease_of_use ~ control + pc_man*manual + pc_onlyMT*only_MT
control ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

lavTestWald(fit, "se_man == 0; se_onlyMT == 0")
lavTestWald(fit, "ps_man == 0; ps_onlyMT == 0")
lavTestWald(fit, "pco_man == 0; pco_onlyMT == 0")
lavTestWald(fit, "pc_man == 0; pc_onlyMT == 0")
lavTestWald(fit, "eou_man == 0; eou_onlyMT == 0")

#sem with causal order with perceived control at the end
s_model <- 'intn =~ ITU1 + ITU2 + ITU3 
satisf =~ PS1 + PS2 + PS3
effectiveness =~ SE1 + SE2 + SE3
comfort =~ PCO1 + PCO2 + PCO3
control =~ PC1 + PC4
ease_of_use =~ EOU1 + EOU2 + EOU3 + EOU4 + EOU5 + EOU7 + EOU8
intn ~ effectiveness + satisf + comfort
effectiveness ~ satisf + comfort + se_man*manual + se_onlyMT*only_MT
satisf ~ ease_of_use 
comfort ~ ease_of_use 
ease_of_use ~ control + pc_man*manual + pc_onlyMT*only_MT
control ~ eou_man*manual + eou_onlyMT*only_MT'
fit <- sem(s_model, data=Integrated_exp_data, ordered = names(Integrated_exp_data[47:77]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)

#graph between exp. conditons and include/not include translation less sensitive
ggplot(Integrated_exp_data, aes(fill=(include_or_not_include_translation_less_sense), y = frequency(include_or_not_include_translation_less_sense), x=Exp_conditions)) + geom_bar(position="fill", stat="identity")                                             

#graph between exp. conditons and include/not include translation high sensitive
#mapping_include <- c("NA" = NA_integer_)
#Integrated_exp_data$include_or_not_include_translation_high_sense <- mapping_include[Integrated_exp_data$include_or_not_include_translation_high_sense]
ggplot(Integrated_exp_data, aes(fill=(include_or_not_include_translation_high_sense), y = frequency(include_or_not_include_translation_high_sense), x=Exp_conditions)) + geom_bar(position="fill", stat="identity")                                             

#graph between preference of translation features and their frequency
ggplot(Integrated_exp_data, aes(fill=(Preferred_trans_tool), y = frequency(Preferred_trans_tool), x=Exp_conditions)) + geom_bar(position="fill", stat="identity")                                             

#glmr
mapping_include_less_sense <- c("yes" = 1, "no" = 0, "NA" = NA)
Integrated_exp_data$include_or_not_include_translation_less_sense <- mapping_include_less_sense[Integrated_exp_data$include_or_not_include_translation_less_sense]
mapping_include_high_sense <- c("yes" = 1, "no" = 0, "NA" = NA)
Integrated_exp_data$include_or_not_include_translation_high_sense <- mapping_include_high_sense[Integrated_exp_data$include_or_not_include_translation_high_sense]


#Integrated_exp_data$include_or_not_include_translation_less_sense <- as.numeric(Integrated_exp_data$include_or_not_include_translation_less_sense) 
baseline <- glm(include_or_not_include_translation_less_sense ~ 1, data = Integrated_exp_data, family = binomial)
randompart <- glmer(include_or_not_include_translation_less_sense ~ 1 + (1|Participant_ID), data=Integrated_exp_data, family=binomial)
pchisq(deviance(baseline)-deviance(randompart), 1,lower=F)
condition <- update(randompart, .~. + Exp_conditions)
anova(randompart, condition)

model <- glmer(include_or_not_include_translation_less_sense ~ Exp_conditions + prompt_less_sens + (1|Participant_ID), data = Integrated_exp_data, family = binomial)
summary(model)
