# Model directory log

# batch size = 8
if [ "$1" = "train" ]; then
  export CQA_DIR=../../data/cqa
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cqa \
         --model_name_or_path roberta-large \
         --do_train \
         --do_eval \
         --train_file train_rand_split.jsonl \
         --eval_file dev_rand_split.jsonl \
         --data_dir $CQA_DIR \
         --learning_rate 1e-5 \
         --max_seq_length 70 \
         --output_dir ./baselines/cqa-roberta-large/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 8 \
         --save_steps 200 \
         --warmup_steps 180 \
         --num_train_epochs 5 \
         --weight_decay 0.01 \
         --adam_epsilon 1e-6 \
         --eval_all_checkpoints \
         --overwrite_output \
         --logits_file logits.txt \
         --save_end_of_epoch

elif [ "$1" = "eval_valid" ]; then
  export CQA_DIR=../../data/cqa
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cqa \
         --model_name_or_path ./baselines/cqa-roberta-large/checkpoint-epoch-2/ \
         --do_eval \
         --train_file train_rand_split.jsonl \
         --eval_file dev_rand_split.jsonl \
         --data_dir $CQA_DIR \
         --learning_rate 1e-5 \
         --max_seq_length 128 \
         --output_dir ./baselines/cqa-roberta-large/checkpoint-epoch-2/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 2 \
         --save_steps 200 \
         --max_steps 3000 \
         --warmup_steps 150 \
         --weight_decay 0.01 \
         --adam_epsilon 1e-6 \
         --logits_file train_logits.txt \
         --eval_all_checkpoints

elif [ "$1" = "eval_test" ]; then
  export CQA_DIR=../../data/cqa
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cqa \
         --model_name_or_path ./baselines/cqa-roberta-large/checkpoint-epoch-2/ \
         --do_test \
         --train_file train_rand_split.jsonl \
         --eval_file test_rand_split_fake_answers.jsonl \
         --data_dir $CQA_DIR \
         --learning_rate 1e-5 \
         --max_seq_length 128 \
         --output_dir ./baselines/cqa-roberta-large/checkpoint-epoch-2/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 2 \
         --save_steps 200 \
         --max_steps 3000 \
         --warmup_steps 150 \
         --weight_decay 0.01 \
         --adam_epsilon 1e-6 \
         --logits_file train_logits.txt \
         --eval_all_checkpoints
fi

# total batch size = 8
# export CQA_DIR=../data/cqa
#export CQA_DIR=./data/
#python ./run_multiple_choice.py \
#       --model_type roberta \
#       --task_name cqa \
#       --model_name_or_path ./models/cnet-cqa-roberta-large/filter-0.34-0.88/cqa/ \
#       --do_eval \
#       --train_file train_rand_split.jsonl \
#       --eval_file test_rand_split_fake_answers.jsonl \
#       --data_dir $CQA_DIR \
#       --learning_rate 1e-5 \
#       --max_seq_length 70 \
#       --output_dir ./models/cqa-roberta-large/eval-temp/ \
#       --per_gpu_eval_batch_size=16 \
#       --per_gpu_train_batch_size=2 \
#       --gradient_accumulation_steps 2 \
#       --overwrite_output \
#       --save_steps 200 \
#       --max_steps 3000 \
#       --warmup_steps 150 \
#       --seed 1 \
#       --weight_decay 0.01 \
#       --adam_epsilon 1e-6
