import json
from StanfordCoreNLP import *
import argparse


def main():
	parser = argparse.ArgumentParser()
	parser.add_argument('-i', '--input', default='', type=str)
	parser.add_argument('-o', '--output', default='', type=str)

	StanfordCoreNLP_chinese_properties = get_StanfordCoreNLP_chinese_properties()
	text = ['陈雪峰回忆，转型门店模式是一个艰难而且不被理解的决定，“投资人担心线下太重，未来的管理成本会很高。这个问题的确存在。”即使如此，投资人最终把决定权交到管理团队手里。 \n当时互联网都在讲轻平台，爱回收为什么越做越重？ \n他的答案很简单，“在我的观念里，轻和重都不是绝对的，应该适应不同行业、不同阶段，两者之间需要一个平衡。之前互联网讲求做轻，但后来发现轻未必是一件好事，我也并没有刻意做重，只是消费末端的门店模式适合现在这个阶段，而且这个业态还没有人尝试过。”',
			'窗前站着一个温柔的姑娘。',
			"窗前站着一个如花似玉的姑娘。",
			'窗前站着一个可爱的姑娘。']

	with CoreNLPClient(
			annotators=['tokenize', 'ssplit', 'pos', 'lemma', 'ner', 'parse', 'depparse', 'coref'],
			properties=StanfordCoreNLP_chinese_properties,
			timeout=30000,
			memory='16G') as client:
		for sent in text:
			ann = client.annotate(sent)
			for i in range(len(ann.sentence)):
				sent_list = [token.word for token in ann.sentence[i].token]
				ner_list = [token.ner for token in ann.sentence[i].token]
				pos_list = [token.pos for token in ann.sentence[i].token]
				ment_list = ann.sentence[i].mentionsForCoref
				basic_deps = ann.sentence[i].basicDependencies
				coref_chains = ann.corefChain
				print("sent_list: ")
				print(sent_list)
			print(len(coref_chains))
			for chain in coref_chains:
				print(chain.chainID)
				print(chain.representative)
				for ment in chain.mention:
					print(ment)
					print(''.join([tok.word for tok in ann.sentence[ment.sentenceIndex].token[ment.beginIndex:ment.endIndex]]))
			#print("")
			#print("ner_list: ")
			#print(ner_list)
			#print("pos list: ")
			#print(pos_list)
			# print("basic dependencies: ")
			# print(basic_deps)
			#print("coref chain: ")
			#print(coref_chains)


if __name__ == '__main__':
	main()