## Installing the requirements

``` 
pip install -r requirements.txt
pip install -r requirements-dev.txt
``` 
### Running the tests

Example test:

```
ENV_FOR_DYNACONF=test nosetests tests/tasks/sample_task/sample_task_test.py 
```

### Running the flows


In order for the cache mechanism to work, run the following:

```
export PREFECT__FLOWS__CHECKPOINTING=true
```

or add it to .bashrc:

```
echo 'export PREFECT__FLOWS__CHECKPOINTING=true' >> ~/.bashrc 

```
 
### Running baselines

Running the baselines for Variable typing and Variable Renaming

```
python -m varslot.flows.baselines.run_transformers_flow --model_name=[MODEL_NAME]
```

Example:
```
python -m varslot.flows.baselines.run_transformers_flow --model_name="bert-base-uncased"
```

Running the baselines for Variable Innoculation.

```
python -m varslot.flows.baselines.run_transformers_flow_innoc --model_name=[MODEL_NAME]
```

Example:
```
python -m varslot.flows.baselines.run_transformers_flow_innoc --model_name="bert-base-uncased"
```

Name of baselines tested:

```
bert-base-uncased
roberta-base
allenai/scibert_scivocab_uncased
tbs17/MathBERT
```

### Running VarSlot

```
 python -m varslot.flows.variable_slot.run_variable_slot_flow 
```


```
python -m varslot.flows.variable_slot.run_variable_slot_innoc_flow
```

