from scipy.stats import norm
import numpy as np
import matplotlib.pyplot as plt


class UnknownDistribution:
    def __init__(self, data):
        self.data = data
        mu, std = norm.fit(self.data)
        self.mu = mu
        self.std = std

    def save(self, output_path, title=None):
        n, bins, patches = plt.hist(x=self.data, bins='auto', color='#0504aa', alpha=0.7, rwidth=0.85)
        plt.grid(axis='y', alpha=0.75)
        plt.xlabel('Value')
        plt.ylabel('Frequency')
        if title is not None:
            plt.title(title)
        plt.suptitle(f"distr. mu = {self.mu:.2f},  std = {self.std:.2f}")
        maxfreq = n.max()
        # Set a clean upper y-axis limit.
        plt.ylim(ymax=np.ceil(maxfreq / 10) * 10 if maxfreq % 10 else maxfreq + 10)
        plt.savefig(output_path)
        plt.close()
