# TED 2020 - Parallel Sentences Corpus

This dataset contains a crawl of nearly 4000 TED (https://www.ted.com/) and TED-X transcripts from July 2020. The transcripts have been translated by a global community of volunteers (https://www.ted.com/participate/translate) to more than 100 languages.

The transcripts for the different languages have been sentence aligned to generate a parallel corpus that can be used to train machine translation systems.


## Download
Tab-Seperated file containing all aligned sentences:
[https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/datasets/ted2020.tsv.gz](https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/datasets/ted2020.tsv.gz)

The ted2020.tsv.gz is a tab-seperated file containing all aligned sentences. The first line specifies the language code. Additionally, the first column is 'talkid' with the information from which talk the sentence stems. 



Source-code & raw JSON data files (not sentence aligned):
[https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/datasets/ted2020-source-files.zip](https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/datasets/ted2020-source-files.zip)





## Usage

You can easily load the dataset using Pandas:
```python
import pandas
import csv

df = pandas.read_csv('ted2020.tsv.gz', sep='\t', keep_default_na=False, encoding='utf8', quoting=csv.QUOTE_NONE)
```



Or with Python CSV reader:
```python
import csv
import gzip

with gzip.open('ted2020.tsv.gz', 'rt', encoding='utf8') as fIn:
   reader = csv.DictReader(fIn, delimiter='\t', quoting=csv.QUOTE_NONE )
   for line in reader:
      print(line)
```



## Statistics
   

| Language | Number of sentences |
| --- | --- |
| Total number of sentences: | 10,544,174 |
| en | 427,436 |
| pt-br | 413,689 |
| es | 412,885 |
| fr | 406,538 |
| ar | 403,716 |
| zh-tw | 400,871 |
| zh-cn | 399,092 |
| ko | 395,661 |
| ru | 386,316 |
| tr | 374,378 |
| it | 369,600 |
| ja | 363,168 |
| he | 348,918 |
| pt | 325,545 |
| ro | 325,459 |
| vi | 323,292 |
| nl | 317,112 |
| hu | 305,455 |
| fa | 301,865 |
| pl | 297,357 |
| de | 293,645 |
| el | 266,861 |
| sr | 258,388 |
| bg | 247,324 |
| uk | 206,100 |
| hr | 195,541 |
| cs | 169,068 |
| id | 163,319 |
| th | 159,145 |
| sv | 119,602 |
| sk | 105,061 |
| lt | 74,765 |
| da | 71,477 |
| sq | 69,194 |
| my | 62,492 |
| ku | 57,597 |
| lv | 54,922 |
| ca | 52,165 |
| hi | 47,116 |
| fi | 44,078 |
| sl | 43,879 |
| mk | 43,867 |
| hy | 36,727 |
| gl | 34,063 |
| fr-ca | 33,149 |
| nb | 28,258 |
| ka | 28,042 |
| mn | 24,597 |
| et | 23,252 |
| mr | 22,756 |
| zh | 16,209 |
| gu | 15,805 |
| ur | 15,569 |
| ms | 11,656 |
| bs | 11,519 |
| az | 11,494 |
| ta | 11,196 |
| eo | 11,098 |
| be | 10,690 |
| bn | 10,401 |
| eu | 10,307 |
| sw | 9,634 |
| kk | 9,513 |
| uz | 6,248 |
| ml | 6,031 |
| te | 5,284 |
| ne | 4,140 |
| fil | 3,380 |
| is | 2,413 |
| sh | 2,314 |
| af | 2,291 |
| kn | 2,266 |
| srp | 2,197 |
| so | 1,980 |
| arq | 1,591 |
| nn | 1,381 |
| tl | 1,182 |
| ug | 1,174 |
| ps | 1,096 |
| km | 1,066 |
| si | 1,032 |
| am | 1,027 |
| bo | 950 |
| pa | 758 |
| ky | 697 |
| tg | 548 |
| lo | 452 |
| ht | 401 |
| mg | 365 |
| tt | 263 |
| inh | 228 |
| tk | 217 |
| ig | 207 |
| mt | 170 |
| dz | 150 |
| ast | 114 |
| szl | 103 |
| ceb | 98 |
| ltg | 88 |
| lb | 88 |
| ga | 79 |
| tlh | 60 |
| as | 41 |
| oc | 32 |
| bi | 31 |
| ha | 26 |
| la | 20 |
| hup | 1 |

Process finished with exit code 0






## Citation
If you use this dataset, we would be happy if you could cite our publication: [Making Monolingual Sentence Embeddings Multilingual using Knowledge Distillation](http://arxiv.org/abs/2004.09813)

```
@article{reimers-2020-multilingual-sentence-bert,
    title = "Making Monolingual Sentence Embeddings Multilingual using Knowledge Distillation",
    author = "Reimers, Nils and Gurevych, Iryna",
    journal= "arXiv preprint arXiv:2004.09813",
    month = "04",
    year = "2020",
    url = "http://arxiv.org/abs/2004.09813",
}
```


## License
Please respect the TED Talks Usage Policy:
https://www.ted.com/about/our-organization/our-policies-terms/ted-talks-usage-policy

The code we provide is licensed under Apache License 2.0


## Notes
Note, not every sentence is translated to the 100 languages. Some talks have been translated only to few languages (see https://www.ted.com/participate/translate/our-languages). If a sentence has no translation, the cell in that file is empty.

Further note that the translators did not translate sentence-by-sentence. This can cause that an English sentences was translated to multiple sentence in the target language. Also, it can be that multiple English sentences where translated to a single sentence in the target language. By using the timings in the transcript, we tried to align the sentences as good as possible. This causes that a column can contain more than one sentence.  

 