import pandas as pd
import matplotlib.pyplot as plt
import matplotlib
matplotlib.style.use('ggplot')

id1 = ['25%', '50%', '75%', '100%']
id2 = ['random', 'top-ret.', 'top-att.']
id3 = ['Original', 'Others', 'Substitute']
colors = ['cornflowerblue', 'whitesmoke', "darkorange"]
print(id1, id2)
df = pd.read_csv('partial-new.csv', index_col=['percentage', 'sample'])
print(df)
fig, axes = plt.subplots(nrows=1, ncols=4, figsize=(17, 5))
font = 21
text_font = 16
offset = 6

ax_position = 0
for concept in df.index.get_level_values('percentage').unique():
    idx = pd.IndexSlice
    subset = df.loc[idx[[concept], :]]

    #                ['cmp_tr_neg_p_wrk', 'exp_tr_pos_p_wrk',
    #                 'cmp_p_spot', 'exp_p_spot']]     
    subset = subset.groupby(
        subset.index.get_level_values('sample')).sum()
    #subset = subset / 4  # quarter hours
    #subset = subset / 100  # installed capacity
    ax = subset.plot(kind="bar", stacked=True, color=colors,
                     ax=axes[ax_position])
    for i, v in enumerate(subset['Original']):
        ax.text(i, v, str(v), ha='center', fontsize=text_font)
    o_list = list(subset['Original']) 
    for i, v in enumerate(subset['Others']):
        ax.text(i, v+o_list[i]-offset, "%2.2f"%(100-(v+o_list[i])), ha='center', in_layout=True, fontsize=text_font)
    ax.set_title("Perturb " + concept, fontsize=font, alpha=1.0)
    ax.set_ylabel("Percentage of All Answers", fontsize=font),
    ax.set_xlabel("Perturb " + concept, fontsize=font, alpha=0.0),
    #ax.set_ylim(0, 9000)
    #ax.set_yticks(range(0, 9000, 1000))
    #ax.set_ytick
    #ax.set_yticklabels(labels=range(0,100,20), fontsize=3.5, rotation=0)
    #ax.set_yticklabels(labels=range(0, 9000, 1000), rotation=0,
    #                   minor=False, fontsize=28)
    ax.set_xticklabels(labels=['random', 'top-ret.', 'top-att.'], rotation=0,
                       minor=False, fontsize=font)
    handles, labels = ax.get_legend_handles_labels()
    #ax.legend(['Market A', 'Market B',
    #           'Market C', 'Market D'],
    #          loc='upper right', fontsize=28
    #          )
    #ax.legend(['Original', 'Others',
    #            'Substitute'],
    #           loc='upper right', fontsize=14)
    ax_position += 1

# look "three subplots"
#plt.tight_layout(pad=0.0, w_pad=-8.0, h_pad=0.0)

# look "one plot"
#plt.tight_layout(pad=2., w_pad=-1.5, h_pad=-10.0)
plt.tight_layout(pad=2.2, w_pad=-1.5, h_pad=-1.0)
axes[1].set_ylabel("")
axes[2].set_ylabel("")
axes[3].set_ylabel("")
#axes[1].set_yticklabels("")
#axes[2].set_yticklabels("")
#axes[3].set_yticklabels("")
axes[0].legend().set_visible(False)
axes[1].legend().set_visible(False)
axes[2].legend().set_visible(False)
for i in range(len(axes)):
    axes[i].set_yticklabels([0, 20, 40, 60, 80, 100], fontsize=text_font+2)
ax.legend(['Original', 'Others',
                'Substitute'],
                bbox_to_anchor=(1,0), loc="lower right", 
                bbox_transform=fig.transFigure, ncol=3, fontsize=font)
                # bbox_to_anchor=(0.5, -0.5, 0.5, 0.5), fontsize=14)

#figure_size = plt.gcf().get_size_inches()
#factor = 0.25
#plt.gcf().set_size_inches(factor * figure_size)

import tikzplotlib

tikzplotlib.save("test.tex")

plt.savefig('nq-ent.png')
