from datetime import datetime
import argparse

import init

parser = argparse.ArgumentParser(description='Expire all remaining HITs so workers cannot do them.')
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
parser.add_argument('--hits', help='HITs to expire', nargs="+", default=[])
args = parser.parse_args()

client = init.get_client(args.sandbox)

hits = client.list_hits(MaxResults=100)
for hit in hits['HITs']:
    if len(args.hits) > 0 and hit['HITId'] not in args.hits:
        continue
    print("Expiring", hit['HITId'])
    response = client.update_expiration_for_hit(
        HITId=hit['HITId'],
        ExpireAt=datetime(2020, 1, 1, 1, 1)
    )
    print(response)
