#include <memory>
#include <iomanip>
#include <cstring>
#include <fstream>
#include <sstream>
#include <unordered_map>

#include "common/token/supertag.h"
#include "include/learning//tree/lca.h"

#include "common/parser/implementations/graph_dp_cjj/graphcjj1L/graphcjj1L_run.h"
#include "common/parser/implementations/graph_dp_cjj/graphcjj2gc_prune/graphcjj2gc_prune_run.h"
#include "common/parser/implementations/graph_merging/graph_decomposer_gg.h"
#include "common/parser/implementations/graph_merging/graph_merging_gg1L/graph_DDdecoder_graph_graph_gg1L.h"
#include "common/parser/implementations/graph_merging/graph_merging_gg2gc/graph_DDdecoder_graph_graph_gg2gc.h"

int main_x(int argc, char * argv[]) {

	std::ios_base::sync_with_stdio(false);
	std::cin.tie(NULL);
	std::cout << std::fixed << std::setprecision(4);

	std::unique_ptr<RunBase> run(nullptr);

	if (strcmp(argv[2], "graphcjj1L") == 0)
		run.reset(new graphcjj1L::Run());
	else if (strcmp(argv[2], "graphcjj2gc") == 0)
		run.reset(new graphcjj2gc_prune::Run());

	if (strcmp(argv[1], "goldtest") == 0) {
		run->goldtest(argv[3], argv[4]);
	}
	else if (strcmp(argv[1], "train") == 0 || strcmp(argv[1],"train+goldtest")==0 ) {

		int iteration = std::atoi(argv[6]);

		std::string current_feature;
		std::string next_feature;
		std::cout << "train start" << std::endl;
		current_feature = next_feature = argv[4];
		next_feature = next_feature.substr(0, next_feature.rfind("/") + strlen("/")) + argv[2] + "_1.feat";

		for (int i = 0; i < iteration; ++i) {
			std::cout << i + 1 <<std::endl;

			run->train(argv[3], current_feature, next_feature);
			if (strcmp(argv[1], "train+goldtest") == 0)
				run->goldtest(argv[5], next_feature);
			current_feature = next_feature;
			std::cout << next_feature << std::endl;
			next_feature = next_feature.substr(0, next_feature.rfind(argv[2]) + strlen(argv[2])) +'_'+ std::to_string(i + 2) + ".feat";
			system("pause");
		}
	}
	else if (strcmp(argv[1], "parse") == 0) {
		run->parse(argv[3], argv[5], argv[4]);
	}
	system("pause");
}

class Option {
public:
	std::string train_graph;
	std::string train_tree;
	std::string model_graph,model_graphA,model_graphB;
	std::string model_tree;
	std::string test;
	std::string out_prefix;
	std::string graph_parser;
	bool decompose;
	bool decomp_unlab;
	bool nopath;
	bool graph_graph;
	bool tree_graph;
	int train_max_iter;
	int test_max_iter;
	tscore test_step;
	Option() {
		test_step = 1000000;
		train_max_iter = 10;
		test_max_iter = 200;
		decomp_unlab = false;
		tree_graph = true;
		graph_graph = false;
		decompose = false;
		nopath = false;;
	}
	static Option* parseOption(int argc, char* argv[]);
};

Option* Option::parseOption(int argc, char* argv[]) {
	Option* ret = new Option();
	for (int i = 1; i < argc; ++i) {
		std::string argi = std::string(argv[i]);
		if (argi == "-train_graph") {
			ret->train_graph = argv[++i];
		} else if (argi == "-train_tree") {
			ret->train_tree = argv[++i];
		} else if (argi == "-model_graph") {
			ret->model_graph = argv[++i];
		} else if (argi == "-model_tree") {
			ret->model_tree = argv[++i];
		} else if (argi == "-model_graphA") {
			ret->model_graphA = argv[++i];
		} else if (argi == "-model_graphB") {
			ret->model_graphB = argv[++i];
		} else if (argi == "-test") {
			ret->test = argv[++i];
		} else if (argi == "-out_prefix") {
			ret->out_prefix = argv[++i];
		} else if (argi == "-train_max_iter") {
			ret->train_max_iter = std::stoi(argv[++i]);
		} else if (argi == "-test_max_iter") {
			ret->test_max_iter = std::stoi(argv[++i]);
		} else if (argi == "-test_step") {
			ret->test_step = std::stoi(argv[++i]);
		} else if (argi == "-graph_graph") {
			ret->graph_graph = true;
			ret->tree_graph = false;
		} else if (argi == "-decompose") {
			ret->decompose = true;
		} else if (argi == "-decomp_unlab") {
			ret->decomp_unlab = true;
		} else if (argi == "-nopath") {
			ret->nopath = true;
		} else if (argi == "-graph_parser")
			ret->graph_parser = argv[++i];
		else {
			std::cerr << "Unknown option: " << argv[i];
			exit(-1);
		}
	}
	return ret;
}

//void registerWPL(std::string inputfile) {
//	DependencyTree ref_sent;
//	std::ifstream input(inputfile);
//	if (input) {
//		while (input >> ref_sent) {
//			for (auto itr = ref_sent.begin(); itr != ref_sent.end(); ++itr) {
//				TWord::code(std::get<0>(std::get<0>(*itr)));
//				TPOSTag::code(std::get<1>(std::get<0>(*itr)));
//				TDepLabel::code(std::get<2>(*itr));
//			}
//		}
//	} else {
//		std::cerr << "register failed, no such file: " << inputfile
//				<< std::endl;
//		exit(-1);
//	}
//}



void train_graph(std::string train, std::string model, std::string test, int max_iter, bool no_path, std::string graphparser) {
	std::string algoname = graphparser;
	std::unique_ptr<RunBase> run;
	if (algoname == "graphcjj1")
		run.reset(new graphcjj1L::Run());
	else if (algoname == "graphcjj2gc")
		run.reset(new graphcjj2gc_prune::Run());
	else {
		std::cout << "no such graph parser"<<std::endl;
		return ;
	}
	/*if (no_path) {
		algoname = "graphcjj2gc_prune_notree";
		graphcjj2gc_prune.reset(new graphcjj2gc_prune_notree::Run());
	}*/
	std::string current_feature;
	std::string next_feature;
	std::cout << algoname + " train start" << std::endl;
	current_feature = next_feature = model;
	next_feature = next_feature + "." + algoname + ".feat";

	for (int i = 0; i < max_iter; ++i) {
		std::cout<<"train_graph iteration : "<<i+1<<std::endl;
		run->train(train, current_feature, next_feature);
		current_feature = next_feature;
	}
}

void train(Option* opt) {

	if (!opt->train_graph.empty()) {
		srand(42);
		train_graph(opt->train_graph, opt->model_graph, opt->test, opt->train_max_iter, opt->nopath,opt->graph_parser);
	}
}



void test1L_gg(Option* opt) {
	std::cout << "test1L_gg begin" << std::endl;
	graph_merging_1L::graph_DDdecoder_graph_graph* decoder = new graph_merging_1L::graph_DDdecoder_graph_graph(opt->model_graphA, opt->model_graphB, opt->test_step);
	decoder->max_iter = opt->test_max_iter;
	std::string graphparser = opt->graph_parser;
	std::ifstream input(opt->test);
	std::ofstream output_graphA(opt->out_prefix + ".graphA.out");
	std::ofstream output_graphB(opt->out_prefix + ".graphB.out");
	std::ofstream output_merge_graph(opt->out_prefix + ".merge_graph.out");
	DependencyGraph test, graphA,graphB,merge_graph;
	Sentence sent;
	int i = 0;
	while (input>>test) {
			std::cout << "test1L_gg " << ++i << " begin" << std::endl;
		sent = test.getSentence();
		decoder->decode(test, graphA, graphB);
		merge_graph.clear();
		merge_graph.merge(graphA,graphB);
		output_graphA<<graphA;
		output_graphB<<graphB;
		output_merge_graph << merge_graph;
	}
	decoder->print_optimal_count();
	input.close();
	output_graphA.close();
	output_graphB.close();
	delete decoder;
}



void test2gc_gg(Option* opt) {
	std::cout << "test2gc_gg begin" << std::endl;
	graph_merging_2gc::graph_DDdecoder_graph_graph* decoder = new graph_merging_2gc::graph_DDdecoder_graph_graph(opt->model_graphA, opt->model_graphB, opt->test_step);
	decoder->max_iter = opt->test_max_iter;
	std::string graphparser = opt->graph_parser;
	std::ifstream input(opt->test);
	std::ofstream output_graphA(opt->out_prefix + ".graphA.out");
	std::ofstream output_graphB(opt->out_prefix + ".graphB.out");
	std::ofstream output_merge_graph(opt->out_prefix + ".merge_graph.out");
	DependencyGraph test, graphA,graphB,merge_graph;
	Sentence sent;
	int i = 0;
	while (input>>test) {
			std::cout << "test2gc_gg " << ++i << " begin" << std::endl;
		sent = test.getSentence();
		decoder->decode(test, graphA, graphB);
		merge_graph.clear();
		merge_graph.merge(graphA,graphB);
		output_graphA<<graphA;
		output_graphB<<graphB;
		output_merge_graph << merge_graph;
	}
	decoder->print_optimal_count();
	input.close();
	output_graphA.close();
	output_graphB.close();
	delete decoder;
}


void decompose_gg(Option* opt) {
	graph_merging::graph_decomposer_gg* decomposer = new graph_merging::graph_decomposer_gg();
	decomposer->unlab = opt->decomp_unlab;
	std::ifstream input(opt->train_graph);
	std::ofstream output_graphA(opt->out_prefix + ".decomposed.graphA.out");
	std::ofstream output_graphB(opt->out_prefix + ".decomposed.graphB.out");

	DependencyGraph graph, decompose_graphA,decompose_graphB;
	int i = 0;
	std::cout << "decompose begin" <<  std::endl;
	while (input >> graph) {
		if (++i % 1000 == 0) {
			std::cout << i << ' ' << "have done\n";
			std::cout.flush();
		}
		decomposer->decompose(graph, decompose_graphA, decompose_graphB);
		output_graphA << decompose_graphA;
		output_graphB << decompose_graphB;
	}
	std::cout << "2direction\n" << decomposer->sumtwodir << std::endl;
	std::cout << "Plannar2 coverage\n"<< decomposer->erroredge << ' ' << decomposer->sumedge << ' ' << 1 - 1.0*decomposer->erroredge / decomposer->sumedge << std::endl;
	std::cout << "CUT0 coverage\n"<< decomposer->cut0graph << ' ' << decomposer->sumgraph << ' ' << 1.0*decomposer->cut0graph / decomposer->sumgraph << std::endl;
	std::cout << "CUT1 coverage\n"<< decomposer->cut1graph << ' ' << decomposer->sumgraph << ' ' << 1.0*decomposer->cut1graph / decomposer->sumgraph << std::endl;
	std::cout << "CUT1+ coverage\n"<< decomposer->cut2graph << ' ' << decomposer->sumgraph << ' ' << 1.0*decomposer->cut2graph / decomposer->sumgraph << std::endl;

	std::cout << std::endl;
	input.close();
	output_graphA.close();
	output_graphB.close();
	delete decomposer;
}

int main(int argc, char* argv[]) {
	Option* opt = Option::parseOption(argc, argv);
	if (opt->decompose) {
		if (opt->graph_graph)
			decompose_gg(opt);
		std::cout << "decomposition done." << std::endl;
		return 0;
	}
	if (opt->train_graph != "") {
		train(opt);
	}
	if (opt->test != "") {
		if (opt->graph_parser == "graphcjj1"){
			if (opt->graph_graph)
				test1L_gg(opt);
		}
		else if (opt->graph_parser == "graphcjj2gc"){
			if (opt->graph_graph)
				test2gc_gg(opt);
		}
	}
	std::cout << "done." << std::endl;
	return 0;
}
