/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class StringKeyAnalyzer
extends AbstractKeyAnalyzer<String>
implements Serializable {
    private static final long serialVersionUID = 7677641007465182788L;
    public static final StringKeyAnalyzer CHAR = new StringKeyAnalyzer(16);
    public static final StringKeyAnalyzer BYTE = new StringKeyAnalyzer(8);
    @Deprecated
    public static final StringKeyAnalyzer INSTANCE = CHAR;
    private final int size;
    private final int msb;

    private StringKeyAnalyzer(int n) {
        this(n, 1 << n - 1);
    }

    private StringKeyAnalyzer(int n, int n2) {
        this.size = n;
        this.msb = n2;
    }

    private int mask(int n) {
        return this.msb >>> n;
    }

    private char valueAt(String string, int n) {
        if (n < string.length()) {
            char c = string.charAt(n);
            if (this.size == 8) {
                c = (char)(c & 0xFF);
            }
            return c;
        }
        return '\u0000';
    }

    @Override
    public int lengthInBits(String string) {
        return string.length() * this.size;
    }

    @Override
    public boolean isBitSet(String string, int n) {
        if (n >= this.lengthInBits(string)) {
            return false;
        }
        int n2 = n / this.size;
        int n3 = n % this.size;
        return (string.charAt(n2) & this.mask(n3)) != 0;
    }

    @Override
    public boolean isPrefix(String string, String string2) {
        return string.startsWith(string2);
    }

    @Override
    public int bitIndex(String string, String string2) {
        boolean bl = true;
        int n = Math.max(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = this.valueAt(string, i);
            if (c2 != (c = this.valueAt(string2, i))) {
                int n2 = c2 ^ c;
                for (int j = 0; j < this.size; ++j) {
                    if ((n2 & this.mask(j)) == 0) continue;
                    return i * this.size + j;
                }
            }
            if (c2 == '\u0000') continue;
            bl = false;
        }
        if (bl) {
            return -1;
        }
        return -2;
    }
}

