/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import org.ardverk.collection.DefaultKeyAnalyzer;
import org.ardverk.collection.KeyAnalyzer;
import org.ardverk.collection.Trie;
import org.ardverk.collection.Tries;

abstract class AbstractTrie<K, V>
extends AbstractMap<K, V>
implements Serializable,
Trie<K, V> {
    private static final long serialVersionUID = -6358111100045408883L;
    protected final KeyAnalyzer<? super K> keyAnalyzer;

    public AbstractTrie() {
        this(DefaultKeyAnalyzer.singleton());
    }

    public AbstractTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        this.keyAnalyzer = Tries.notNull(keyAnalyzer, "keyAnalyzer");
    }

    public KeyAnalyzer<? super K> getKeyAnalyzer() {
        return this.keyAnalyzer;
    }

    @Override
    public K selectKey(K k) {
        Map.Entry entry = this.select(k);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public V selectValue(K k) {
        Map.Entry entry = this.select(k);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Trie[").append(this.size()).append("]={\n");
        for (Map.Entry entry : this.entrySet()) {
            stringBuilder.append("  ").append(entry).append("\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final int lengthInBits(K k) {
        if (k == null) {
            return 0;
        }
        return this.keyAnalyzer.lengthInBits(k);
    }

    final boolean isBitSet(K k, int n) {
        if (k == null) {
            return false;
        }
        return this.keyAnalyzer.isBitSet(k, n);
    }

    final int bitIndex(K k, K k2) {
        if (k != null && k2 != null) {
            return this.keyAnalyzer.bitIndex(k, k2);
        }
        if (k != null && k2 == null) {
            return this.bitIndex(k);
        }
        if (k == null && k2 != null) {
            return this.bitIndex(k2);
        }
        return -1;
    }

    private int bitIndex(K k) {
        int n = this.lengthInBits(k);
        for (int i = 0; i < n; ++i) {
            if (!this.isBitSet(k, i)) continue;
            return i;
        }
        return -1;
    }

    final boolean compareKeys(K k, K k2) {
        if (k == null) {
            return k2 == null;
        }
        if (k2 == null) {
            return k == null;
        }
        return this.keyAnalyzer.compare(k, k2) == 0;
    }

    static abstract class BasicEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -944364551314110330L;
        protected K key;
        protected V value;
        private transient int hashCode = 0;

        public BasicEntry(K k) {
            this.key = k;
        }

        public BasicEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public V setKeyValue(K k, V v) {
            this.key = k;
            this.hashCode = 0;
            return this.setValue(v);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.key != null ? this.key.hashCode() : 0;
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Tries.areEqual(this.key, entry.getKey()) && Tries.areEqual(this.value, entry.getValue());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

