/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.ReusableStringReader;

final class DocInverterPerThread
extends DocFieldConsumerPerThread {
    final DocInverter docInverter;
    final InvertedDocConsumerPerThread consumer;
    final InvertedDocEndConsumerPerThread endConsumer;
    final Token localToken = new Token();
    final DocumentsWriter.DocState docState;
    final DocInverter.FieldInvertState fieldState = new DocInverter.FieldInvertState();
    final ReusableStringReader stringReader = new ReusableStringReader();

    public DocInverterPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocInverter docInverter) {
        this.docInverter = docInverter;
        this.docState = docFieldProcessorPerThread.docState;
        this.consumer = docInverter.consumer.addThread(this);
        this.endConsumer = docInverter.endConsumer.addThread(this);
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        this.endConsumer.startDocument();
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        this.endConsumer.finishDocument();
        return this.consumer.finishDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        try {
            this.consumer.abort();
            Object var2_1 = null;
            this.endConsumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endConsumer.abort();
            throw throwable;
        }
    }

    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocInverterPerField(this, fi);
    }
}

