/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;

public class StandardTokenizer
extends Tokenizer {
    private final StandardTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int ACRONYM_DEP = 8;
    public static final String[] TOKEN_TYPES;
    public static final String[] tokenImage;
    private boolean replaceInvalidAcronym = false;
    private int maxTokenLength = 255;
    static final /* synthetic */ boolean $assertionsDisabled;

    void setInput(Reader reader) {
        this.input = reader;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer(Reader input) {
        this.input = input;
        this.scanner = new StandardTokenizerImpl(input);
    }

    public StandardTokenizer(Reader input, boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
        this.input = input;
        this.scanner = new StandardTokenizerImpl(input);
    }

    public Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        int posIncr = 1;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                reusableToken.clear();
                reusableToken.setPositionIncrement(posIncr);
                this.scanner.getText(reusableToken);
                int start = this.scanner.yychar();
                reusableToken.setStartOffset(start);
                reusableToken.setEndOffset(start + reusableToken.termLength());
                if (tokenType == 8) {
                    if (this.replaceInvalidAcronym) {
                        reusableToken.setType(StandardTokenizerImpl.TOKEN_TYPES[5]);
                        reusableToken.setTermLength(reusableToken.termLength() - 1);
                    } else {
                        reusableToken.setType(StandardTokenizerImpl.TOKEN_TYPES[2]);
                    }
                } else {
                    reusableToken.setType(StandardTokenizerImpl.TOKEN_TYPES[tokenType]);
                }
                return reusableToken;
            }
            ++posIncr;
        }
        return null;
    }

    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }

    public void reset(Reader reader) throws IOException {
        this.input = reader;
        this.reset();
    }

    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    static {
        $assertionsDisabled = !StandardTokenizer.class.desiredAssertionStatus();
        TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>"};
        tokenImage = TOKEN_TYPES;
    }
}

