/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Vector;
import jigsaw.syntax.BitRecChart;
import jigsaw.syntax.Grammar;
import jigsaw.syntax.Rule;

public class ParseForest {
    private BitRecChart _chart = null;
    private Grammar _g = null;
    private BitRecChart _ichart = null;
    protected Vector<Integer> catname = new Vector();
    protected Vector<Integer> firstanalysis = new Vector();
    protected Vector<Integer> rulenumber = new Vector();
    protected Vector<Integer> firstchild = new Vector();
    protected Vector<Integer> child = new Vector();
    private HashMap<Integer, Integer> _nodemap = new HashMap();

    public ParseForest() {
    }

    public ParseForest(BitRecChart chart, BitRecChart ichart, Grammar g) {
        this._chart = chart;
        this._g = g;
        this._ichart = ichart;
        this.buildSubtree((short)0, (short)this._chart.maxpos(), g.NT(g.Start()));
    }

    public int newNode(short start, short end, int A) {
        int n = this.catname.size();
        this.catname.add(A);
        int idx = this._chart.pagesize() * A + end * (end - 1) / 2 + start;
        this._nodemap.put(idx, n);
        this.firstanalysis.add(this.firstchild.size());
        return n;
    }

    public int getNode(short start, short end, int A) {
        int idx = this._chart.pagesize() * A + end * (end - 1) / 2 + start;
        if (this._nodemap.containsKey(idx)) {
            return this._nodemap.get(idx);
        }
        return -1;
    }

    public void addAnalysis(int node, int ridx, short mid, Vector<int[]> localas) {
        int first = this.child.size();
        this.child.add(-1);
        this.child.add(-1);
        this.firstchild.add(first);
        int[] analysis = new int[]{ridx, mid};
        localas.add(analysis);
        this.rulenumber.add(ridx);
    }

    public void addAnalysis(int node, int ridx, Vector<int[]> localas) {
        int first = this.child.size();
        this.child.add(-1);
        this.firstchild.add(first);
        int[] analysis = new int[]{ridx, -1};
        localas.add(analysis);
        this.rulenumber.add(ridx);
    }

    public void addChild(int cidx, int cnode) {
        this.child.set(cidx, cnode);
    }

    public int buildSubtree(short start, short end, int A) {
        int n = this.getNode(start, end, A);
        if (n == -1) {
            n = this.newNode(start, end, A);
            Vector<int[]> analyses = new Vector<int[]>();
            for (Rule r : this._g.trules(A)) {
                int ti = this._g.T2i(r.rhs()[0]);
                if (!this._ichart.get(start, end, ti)) continue;
                this.addAnalysis(n, r.id(), analyses);
            }
            for (Rule r : this._g.chainrules(A)) {
                if (!this._chart.get(start, end, r.rhs()[0])) continue;
                this.addAnalysis(n, r.id(), analyses);
            }
            if (end > start + 1) {
                for (Rule r : this._g.birules(A)) {
                    BitSet vec1 = this._chart.getVectorByStart(start, (short)(end - start - 1), r.rhs()[0]);
                    BitSet vec2 = this._chart.getVectorByEnd(end, (short)(end - start - 1), r.rhs()[1]);
                    vec1.and(vec2);
                    int m = vec1.nextSetBit(0);
                    while (m >= 0) {
                        this.addAnalysis(n, r.id(), (short)(start + m + 1), analyses);
                        m = vec1.nextSetBit(m + 1);
                    }
                }
            }
            int i = 0;
            while (i < analyses.size()) {
                int[] a = (int[])analyses.get(i);
                int aidx = this.firstanalysis.get(n) + i;
                Rule r = this._g.rules().get(a[0]);
                int fc = this.firstchild.get(aidx);
                if (a[1] == -1) {
                    if (r.rhs()[0] < 0) {
                        this.addChild(fc, -end);
                    } else {
                        int d = this.buildSubtree(start, end, r.rhs()[0]);
                        this.addChild(fc, d);
                    }
                } else {
                    short mid = (short)a[1];
                    int d = this.buildSubtree(start, mid, r.rhs()[0]);
                    this.addChild(fc, d);
                    d = this.buildSubtree(mid, end, r.rhs()[1]);
                    this.addChild(fc + 1, d);
                }
                ++i;
            }
        }
        return n;
    }

    public void debugPrint() {
        System.out.print("catname=[");
        for (int name : this.catname) {
            System.out.print(" " + this._g.NT(name));
        }
        System.out.println(" ]");
        System.out.print("catnum=[");
        for (int num : this.catname) {
            System.out.print(" " + num);
        }
        System.out.println(" ]");
        System.out.print("first-analysis=[");
        for (int fa : this.firstanalysis) {
            System.out.print(" " + fa);
        }
        System.out.println(" ]");
        System.out.print("rule-number=[");
        for (int rn : this.rulenumber) {
            System.out.print(" " + rn);
        }
        System.out.println(" ]");
        System.out.print("first-child=[");
        for (int fc : this.firstchild) {
            System.out.print(" " + fc);
        }
        System.out.println(" ]");
        System.out.print("child=[");
        for (int c : this.child) {
            System.out.print(" " + c);
        }
        System.out.println(" ]");
    }

    public static void main(String[] args) {
    }
}

