/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.DirRecordNode;
import fig.record.FileRecordNode;
import fig.record.FullRecordNode;
import fig.record.LoadFileState;
import fig.record.RecordNode;
import java.io.File;
import java.util.Date;
import java.util.List;

public abstract class PathRecordNode
extends FullRecordNode {
    private File path;
    protected LoadFileState state;
    protected long lastLoadedTime;

    public PathRecordNode(LoadFileState state, String key, String value, File path) {
        super(key, value);
        this.state = state;
        this.path = path;
    }

    public PathRecordNode(LoadFileState state, File path) {
        super(path.getName(), null);
        this.state = state;
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public List<RecordNode> getChildren() {
        if (this.outOfDate()) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    @Override
    public List<RecordNode> getChildren(String key) {
        if (this.outOfDate()) {
            this.loadChildren();
        }
        return super.getChildren(key);
    }

    @Override
    public int numChildren() {
        if (this.outOfDate()) {
            this.loadChildren();
        }
        return super.numChildren();
    }

    @Override
    public int numChildren(String key) {
        if (this.outOfDate()) {
            this.loadChildren();
        }
        return super.numChildren(key);
    }

    public static PathRecordNode newPathNode(DirRecordNode parent, LoadFileState state, String name) {
        File file = parent == null ? new File(name) : new File(parent.getPath(), name);
        if (file.isDirectory()) {
            return new DirRecordNode(state, file);
        }
        if (file.isFile()) {
            return new FileRecordNode(state, file);
        }
        return null;
    }

    public void loadChildren() {
        this.lastLoadedTime = new Date().getTime();
    }

    public void unloadChildren() {
        this.clearChildren();
        this.lastLoadedTime = 0L;
    }

    public boolean isChildrenLoaded() {
        return this.lastLoadedTime > 0L;
    }

    public boolean outOfDate() {
        return this.getPath().lastModified() > this.lastLoadedTime;
    }

    protected PathRecordNode disableLoading() {
        this.lastLoadedTime = Long.MAX_VALUE;
        return this;
    }
}

