/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.Mandate;
import fig.record.ReceiverInterface;
import java.rmi.RemoteException;

public class BufferedReceiver
implements ReceiverInterface {
    private ReceiverInterface receiver;
    private StringBuilder sb;

    public BufferedReceiver(ReceiverInterface receiver) {
        this.receiver = receiver;
        this.sb = new StringBuilder();
    }

    @Override
    public void flush() throws RemoteException {
        this.receiver.printOut(this.sb.toString());
        this.sb = new StringBuilder();
    }

    @Override
    public void printOut(String s) throws RemoteException {
        this.sb.append(s);
        if (this.sb.length() >= 16384) {
            this.flush();
        }
    }

    @Override
    public void printErr(String s) throws RemoteException {
        this.receiver.printErr(s);
    }

    @Override
    public void executeMandate(Mandate mandate) throws RemoteException {
        this.receiver.executeMandate(mandate);
    }
}

