/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.MapUtils;
import fig.basic.OrderedStringMap;
import fig.basic.Pair;
import fig.basic.StopWatch;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class StopWatchSet {
    private static Map<String, StopWatch> stopWatches = new LinkedHashMap<String, StopWatch>();
    private static ThreadLocal<LinkedList<Pair<String, StopWatch>>> lastStopWatches = new ThreadLocal(){

        protected LinkedList<Pair<String, StopWatch>> initialValue() {
            return new LinkedList<Pair<String, StopWatch>>();
        }
    };

    public static synchronized StopWatch getWatch(String s) {
        return MapUtils.getMut(stopWatches, s, new StopWatch());
    }

    public static void begin(String s) {
        lastStopWatches.get().addLast(new Pair<String, StopWatch>(s, new StopWatch().start()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end() {
        Pair<String, StopWatch> pair = lastStopWatches.get().removeLast();
        pair.getSecond().stop();
        Map<String, StopWatch> map = stopWatches;
        synchronized (map) {
            StopWatchSet.getWatch(pair.getFirst()).add(pair.getSecond());
        }
    }

    public static synchronized OrderedStringMap getStats() {
        OrderedStringMap map = new OrderedStringMap();
        for (String key : stopWatches.keySet()) {
            StopWatch watch = StopWatchSet.getWatch(key);
            map.put(key, watch + " (" + new StopWatch(watch.n == 0 ? 0L : watch.ms / (long)watch.n) + " x " + watch.n + ")");
        }
        return map;
    }
}

