/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import fig.basic.IdentityHashSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class SetFactory<K>
implements Serializable {
    public abstract Set<K> buildSet();

    public static class HashSetFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new HashSet();
        }
    }

    public static class IdentityHashMapFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new IdentityHashSet();
        }
    }

    public static class TreeMapFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new TreeSet();
        }
    }
}

