/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CategoryObject;
import SyntaxUtils.CCGRule;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;

public class CCGBinaryRule
extends CCGRule {
    public String left;
    public String right;
    public RuleType type;
    public static int[] typeHead;
    public static EnumMap<RuleType, Method> typeMethod;
    public static EnumMap<RuleType, Method> tryAllMethod;

    static {
        int[] nArray = new int[14];
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[12] = 1;
        typeHead = nArray;
        typeMethod = new EnumMap(RuleType.class);
        tryAllMethod = new EnumMap(RuleType.class);
        RuleType[] types = RuleType.values();
        int i = 0;
        while (i < types.length) {
            try {
                typeMethod.put(types[i], CategoryObject.class.getDeclaredMethod(types[i].toString(), CategoryObject.class, CategoryObject.class, CategoryObject.class, Map.class));
                tryAllMethod.put(types[i], CategoryObject.class.getDeclaredMethod(types[i].toString(), CategoryObject.class, CategoryObject.class));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public CCGBinaryRule(String left, String right, String result, int head) {
        this.left = left;
        this.right = right;
        this.result = result;
        this.type = CCGBinaryRule.classifier(left, right, result);
        this.freq = 1;
        this.headChild = head;
    }

    public CCGBinaryRule(String left, String right, String result, int head, int freq) {
        this(left, right, result, head);
        this.freq = freq;
    }

    public CCGBinaryRule(String io) {
        String[] ss = io.split("\\s+");
        this.freq = Integer.parseInt(ss[0].trim());
        this.type = RuleType.values()[Integer.parseInt(ss[2].trim())];
        this.headChild = Integer.parseInt(ss[4].trim());
        this.result = ss[6];
        this.left = ss[8];
        this.right = ss[9];
    }

    @Override
    public String key() {
        return CCGBinaryRule.key(this.left, this.right);
    }

    public static String key(String left, String right) {
        return String.valueOf(left) + "+" + right;
    }

    protected static RuleType classifier(String left, String right, String result) {
        CategoryObject lc = CategoryObject.fromPlainCat(left);
        CategoryObject rc = CategoryObject.fromPlainCat(right);
        CategoryObject res = CategoryObject.fromPlainCat(result);
        RuleType[] types = RuleType.values();
        int i = 0;
        while (i < types.length) {
            Method m = typeMethod.get((Object)types[i]);
            try {
                if (((Boolean)m.invoke(null, lc, rc, res, null)).booleanValue()) {
                    return types[i];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return RuleType.unknown;
    }

    @Override
    public int arity() {
        return 2;
    }

    public static CCGBinaryRule tryAllRules(CategoryObject left, CategoryObject right) {
        try {
            Object res = null;
            RuleType[] types = RuleType.values();
            int i = 0;
            while (i < types.length - 1) {
                Method m = tryAllMethod.get((Object)types[i]);
                res = m.invoke(null, left, right);
                if (res != null) {
                    CCGBinaryRule bRule = new CCGBinaryRule(left.toString(), right.toString(), res.toString(), typeHead[i]);
                    return bRule;
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CategoryObject perform(CategoryObject left, CategoryObject right, Map<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject> indices) {
        CategoryObject res = CategoryObject.fromPlainCat(this.result);
        Method m = typeMethod.get((Object)this.type);
        try {
            if (m != null && ((Boolean)m.invoke(null, left, right, res, indices)).booleanValue()) {
                return res;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CCGBinaryRule)) {
            return false;
        }
        CCGBinaryRule that = (CCGBinaryRule)o;
        if (that.type != this.type) {
            return false;
        }
        return that.left.equals(this.left) && that.right.equals(this.right) && that.result.equals(this.result) && that.headChild == this.headChild;
    }

    public int hashCode() {
        return this.result.hashCode() + this.headChild;
    }

    @Override
    public int typeOrdinal() {
        return this.type.ordinal();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.freq) + " # ");
        sb.append(String.valueOf(this.typeOrdinal()) + " # ");
        sb.append(String.valueOf(this.headChild) + " # ");
        sb.append(String.valueOf(this.result) + " --> ");
        sb.append(String.valueOf(this.left) + " " + this.right);
        return sb.toString();
    }

    public static void main(String[] args) {
        CCGBinaryRule test = new CCGBinaryRule("NP", "S\\NP", "S", 1, 5);
        System.out.println(test);
        System.out.println((Object)test.type);
        test = new CCGBinaryRule("NP", "NP", "S", 0, 8);
        System.out.println(test);
        System.out.println((Object)test.type);
        String s = test.toString();
        CCGBinaryRule newRule = new CCGBinaryRule(s);
        System.out.println(newRule.toString());
    }

    public static enum RuleType {
        coordination,
        forwardApply,
        backwardApply,
        simpleForwardCompose,
        simpleBackwardCompose,
        crossBackwardCompose,
        crossForwardCompose,
        generalizedForwardCompose,
        generalizedBackwardCompose,
        generalizedForwardCrossCompose,
        generalizedBackwardCrossCompose,
        forwardSubstitute,
        backwardSubstitute,
        unknown;

    }
}

