/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;

public class PUtil {
    public static long DEFAULT_ACTIVITY_STEP_RATE = 20L;
    public static int ACTIVITY_SCHEDULER_FRAME_DELAY = 10;
    public static Iterator NULL_ITERATOR = Collections.EMPTY_LIST.iterator();
    private static final int PATH_TERMINATOR = -1;
    public static Enumeration NULL_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    public static OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] byArray) {
        }

        public void write(byte[] byArray, int n, int n2) {
        }

        public void write(int n) {
        }
    };

    public static PCamera createBasicScenegraph() {
        PRoot pRoot = new PRoot();
        PLayer pLayer = new PLayer();
        PCamera pCamera = new PCamera();
        pRoot.addChild(pCamera);
        pRoot.addChild(pLayer);
        pCamera.addLayer(pLayer);
        return pCamera;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream objectOutputStream) throws IOException {
        if (stroke instanceof Serializable) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(stroke);
        } else if (stroke instanceof BasicStroke) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeBoolean(false);
            PUtil.writeBasicStroke((BasicStroke)stroke, objectOutputStream);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private static void writeBasicStroke(BasicStroke basicStroke, ObjectOutputStream objectOutputStream) throws IOException {
        float[] fArray = basicStroke.getDashArray();
        if (fArray == null) {
            objectOutputStream.write(0);
        } else {
            objectOutputStream.write(fArray.length);
            for (int i = 0; i < fArray.length; ++i) {
                objectOutputStream.writeFloat(fArray[i]);
            }
        }
        objectOutputStream.writeFloat(basicStroke.getLineWidth());
        objectOutputStream.writeInt(basicStroke.getEndCap());
        objectOutputStream.writeInt(basicStroke.getLineJoin());
        objectOutputStream.writeFloat(basicStroke.getMiterLimit());
        objectOutputStream.writeFloat(basicStroke.getDashPhase());
    }

    public static Stroke readStroke(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            return null;
        }
        boolean bl2 = objectInputStream.readBoolean();
        if (bl2) {
            return (Stroke)objectInputStream.readObject();
        }
        return PUtil.readBasicStroke(objectInputStream);
    }

    private static Stroke readBasicStroke(ObjectInputStream objectInputStream) throws IOException {
        float[] fArray = null;
        int n = objectInputStream.read();
        if (n != 0) {
            fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = objectInputStream.readFloat();
            }
        }
        float f = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        float f2 = objectInputStream.readFloat();
        float f3 = objectInputStream.readFloat();
        return new BasicStroke(f, n2, n3, f2, fArray, f3);
    }

    public static GeneralPath readPath(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        GeneralPath generalPath = new GeneralPath();
        block8: while (true) {
            int n = objectInputStream.readInt();
            switch (n) {
                case 0: {
                    generalPath.moveTo(objectInputStream.readFloat(), objectInputStream.readFloat());
                    continue block8;
                }
                case 1: {
                    generalPath.lineTo(objectInputStream.readFloat(), objectInputStream.readFloat());
                    continue block8;
                }
                case 2: {
                    generalPath.quadTo(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
                    continue block8;
                }
                case 3: {
                    generalPath.curveTo(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
                    continue block8;
                }
                case 4: {
                    generalPath.closePath();
                    continue block8;
                }
                case -1: {
                    return generalPath;
                }
            }
            break;
        }
        throw new IOException("Unknown path type encountered while deserializing path.");
    }

    public static void writePath(GeneralPath generalPath, ObjectOutputStream objectOutputStream) throws IOException {
        PathIterator pathIterator = generalPath.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    objectOutputStream.writeInt(0);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 1: {
                    objectOutputStream.writeInt(1);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 2: {
                    objectOutputStream.writeInt(2);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    break;
                }
                case 3: {
                    objectOutputStream.writeInt(3);
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    objectOutputStream.writeFloat(fArray[4]);
                    objectOutputStream.writeFloat(fArray[5]);
                    break;
                }
                case 4: {
                    objectOutputStream.writeInt(4);
                    break;
                }
                default: {
                    throw new IOException("Unknown path type encountered while serializing path.");
                }
            }
            pathIterator.next();
        }
        objectOutputStream.writeInt(-1);
    }
}

