import torch
import torch.nn as nn
from tqdm import tqdm
from torch.autograd import Variable
from batch_generator import *
from torch.nn.utils.rnn import pack_padded_sequence, pad_packed_sequence
import time
from itertools import chain
from custom_rnn import *

# Hyper Parameters
embedding_size = 300
context_size = 600
depth = 5
filter_size = 100
kernel_size = 3
num_classes = 10
batch_size = 128
iter_size = 128
iter_num = batch_size // iter_size
num_epochs = 2
init_learning_rate = [0.001, 0.001, 0.001]
os.environ["CUDA_VISIBLE_DEVICES"] = "0"
device="cuda"
# train_filename='imdb_tr.pkl'
# test_filename='imdb_te.pkl'
# dic_filename='imdb_dic.pkl'

def get_maxlen(df_name):
    df = load_file(df_name)
    ls = df['len'].tolist()
    ls = [sum(l) for l in ls]
    return max(ls)


# train_filename='data/text_classification/yahoo/allen/train_v.pkl'
# test_filename='data/text_classification/yahoo/allen/val.pkl'
train_filename='../data/text_classification/yahoo/allen/train.pkl'
test_filename='../data/text_classification/yahoo/allen/test.pkl'
dic_filename='../data/text_classification/yahoo/allen/dictionary.pkl'
# glove_filename = None
glove_filename= '../data/text_classification/yahoo/allen/glove.pkl'

dic = load_file(dic_filename)
trdf = load_file(train_filename)
tedf = load_file(test_filename)
tr = BucketedDataIterator(trdf,dic, 20,char_embedding=False, max_len=1000)
te = BucketedDataIterator(tedf,dic,char_embedding=False,oov_index=tr.oov_index, max_len=1000)
vocab_size = tr.oov_index + 1
# maxlen = get_maxlen(train_filename)


def adjust_learning_rate(optimizer, lr):
    for param_group in optimizer.param_groups:
        param_group['lr'] = lr
    return optimizer


class Dynamic_Fc(nn.Module):
    def __init__(self, context_size,input_size, num_class):
        super(Dynamic_Fc, self).__init__()
        self.context_size = context_size
        self.num_class = num_class
        self.input_size = input_size
        self.std = math.sqrt(2 / (input_size*num_class))
        self.fc = nn.Linear(context_size,input_size*num_class)
        self.reset_parameters()

    def reset_parameters(self):
        # nn.init.xavier_normal_(self.fc.weight)
        nn.init.kaiming_normal_(self.fc.weight,nonlinearity='linear')
        nn.init.constant_(self.fc.bias,val=0)

    def forward(self,context,x):
        fc_weight = self.fc(context) # [b,i*c]
        mean = fc_weight.mean(-1, keepdim=True)
        std = fc_weight.std(-1, keepdim=True)
        fc_weight = ((fc_weight - mean) / std) * self.std
        fc_weight = fc_weight.view(-1,self.input_size,self.num_class)
        out = torch.bmm(x.unsqueeze(1),fc_weight).squeeze(1)
        return out


class Dynamic_Conv(nn.Module):
    def __init__(self, context_size, infilter_size, outfilter_size, kernel_size,context_gen=True):
        super(Dynamic_Conv, self).__init__()
        self.context_size = context_size
        # self.context_size = infilter_size
        self.infilter_size = infilter_size
        self.outfilter_size = outfilter_size
        self.kernel_size = kernel_size
        self.context_gen = context_gen
        self.padding_size = int((kernel_size - 1) / 2)
        conv_dims = outfilter_size * infilter_size * kernel_size
        self.std_conv = math.sqrt(2 / (outfilter_size + infilter_size * kernel_size))
        self.convs = nn.Sequential(nn.Linear(context_size, conv_dims))

        self.std_conv = math.sqrt(2 / (outfilter_size + infilter_size * kernel_size))

        self.ln = nn.LayerNorm(outfilter_size)
        self.reset_parameters()

    def reset_parameters(self):
        for i in self.convs:
            if isinstance(i, nn.Linear):
                # nn.init.normal_(i.weight,0,0.01)
                nn.init.kaiming_normal_(i.weight,nonlinearity='relu')
                # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
                nn.init.constant_(i.bias, val=0)


    def forward(self,context, x):
        """
        :param x: [batch, lens, channel]
        :return: context [batch,context_size], x [batch,lens,channel]
        """
        device = x.device
        batch_size = x.size(0)
        # print(x.size(),self.context_size,self.weight_size)
        # temp = F.unfold(x,kernel_size=self.kernel_size,padding=int((self.kernel_size - 1) / 2))
        temp = x.unfold(1, self.kernel_size, 1).contiguous()
        if self.padding_size:
            padding = torch.zeros(batch_size, self.padding_size, self.infilter_size, self.kernel_size).to(device)
            temp = torch.cat([padding, temp, padding], 1)
        temp = temp.view(temp.size(0), temp.size(1), -1)  # [batch, len, in*k]

        conv_weight = self.convs(context)
        mean = conv_weight.mean(1, keepdim=True)
        std = conv_weight.std(1, keepdim=True)
        conv_weight = ((conv_weight - mean) / std) * self.std_conv * math.sqrt(2)
        conv_weight = conv_weight.view(batch_size, self.infilter_size * self.kernel_size, -1)


        if self.context_gen:
            new_context = context

        out = torch.bmm(temp, conv_weight) #+ bias.unsqueeze(1)
        out = F.relu(out)
        if self.context_gen:
            context = new_context
        return context, out


class Conv_Block(nn.Module):
    def __init__(self, context_size, inchannel, outchannel, kernel_size=3, shortcut=True, last_block=False):
        super(Conv_Block, self).__init__()
        self.padding = int((kernel_size - 1) / 2)
        self.kernel_size = kernel_size
        self.context_size = context_size
        self.inchannel = inchannel
        self.outchannel = outchannel
        self.conv = nn.ModuleList()
        self.gru = nn.GRU(inchannel, context_size // 2, 1, batch_first=True, bidirectional=True)
        self.self_att_vec = Parameter(torch.Tensor(context_size))
        self.att_vec_g = Parameter(torch.Tensor([1.0]))
        self.conv.append(Dynamic_Conv(context_size,inchannel,outchannel,kernel_size,False))
        self.conv.append(Dynamic_Conv(context_size,outchannel,outchannel,kernel_size,not last_block))
        self.shortcut = shortcut
        if shortcut:
            self.shortcut_connection = nn.Sequential(nn.Linear(inchannel,outchannel))

        self.ln = nn.LayerNorm(outchannel)
        self.reset_parameters()

    def reset_parameters(self):
        if self.shortcut:
            for i in self.shortcut_connection:
                if isinstance(i, nn.Linear):
                    # nn.init.normal_(i.weight, 0, 0.01)
                    # nn.init.xavier_normal_(i.weight)
                    nn.init.kaiming_normal_(i.weight, nonlinearity='relu')
                    nn.init.constant_(i.bias, val=0)
        # for i in self.latent_trans:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight, nonlinearity='tanh')
        #         nn.init.constant_(i.bias, val=0)
        nn.init.normal_(self.self_att_vec.data, std=1.0 / math.sqrt(self.context_size))
        stdv = math.sqrt(1.0 / (self.inchannel))
        stdv_1 = math.sqrt(1.0 / (self.context_size))
        for name, param in self.gru.named_parameters():
            if 'bias' in name:
                nn.init.constant_(param, val=0)
                # if 'l0' in name:
                #     nn.init.normal_(param, 0, stdv)
                # else:
                #     nn.init.normal_(param, 0, stdv_1)
            elif 'weight' in name:
                if 'l0' in name:
                    # nn.init.xavier_normal_(param)
                    nn.init.normal_(param, 0, stdv)
                else:
                    nn.init.normal_(param, 0, stdv_1)

    def forward(self, x, seq_lengths):
        # context = F.max_pool1d(x.transpose(1,2),x.size(1)).squeeze()

        packed_input = pack_padded_sequence(x, seq_lengths, batch_first=True)
        packed_output, _ = self.gru(packed_input, None)
        out_rnn, _ = pad_packed_sequence(packed_output, batch_first=True)
        # out_rnn = self.latent_trans(out_rnn)
        att_vec = self.att_vec_g * (self.self_att_vec / torch.sqrt(torch.sum(self.self_att_vec ** 2)))
        # att_vec = self.self_att_vec
        att_vec = att_vec.unsqueeze(0).unsqueeze(0)
        logits = torch.sum(torch.mul(out_rnn, att_vec), -1)
        att = softmax_with_len(logits, seq_lengths).unsqueeze(-1)  # [b, l]
        context = torch.sum(out_rnn * att, 1)

        context, x_ = self.conv[0](context,x)
        # x_ = self.ln1(x_.contiguous().view(-1,self.outchannel)).view_as(x_)
        context, x_ = self.conv[1](context,x_)
        # x_ = self.ln2(x_.contiguous().view(-1, self.outchannel)).view_as(x_)
        if self.shortcut:
            sc = self.shortcut_connection(x)
            sc = self.ln(sc)
            out = 0.5*(sc + x_)
            # out = self.ln(out)
        else:
            out = x_
        out = F.max_pool1d(out.transpose(1,2),self.kernel_size,2,self.padding).transpose(1,2)
        out = self.ln(out.contiguous().view(-1,self.outchannel)).view_as(out)
        return context, out


class DPCNN(nn.Module):
    def __init__(self, embed_size, context_size, num_classes, filter_size=250,kernel_size=3,depth=7,shortcut=True):
        super(DPCNN, self).__init__()
        self.min_len = 2 ** (depth + 1)
        self.embed_size = embed_size
        self.filter_size = filter_size
        self.kernel_size = kernel_size
        self.context_size = context_size
        self.shortcut = shortcut
        self.depth = depth
        self.embed = Word_embedding(embed_size,vocab_size,glove_filename,dic)
        self.convs = nn.ModuleList()
        for i in range(depth):
            if i ==0:
                self.convs.append(Conv_Block(context_size, embed_size, filter_size,kernel_size=kernel_size,shortcut=shortcut))
            else:
                self.convs.append(Conv_Block(context_size, filter_size, filter_size, kernel_size=kernel_size, shortcut=shortcut))
        # self.fc = Dynamic_Fc(context_size,filter_size,num_classes)
        self.fc = nn.Linear(filter_size,num_classes)
        nn.init.kaiming_normal_(self.fc.weight, nonlinearity='linear')
        # nn.init.xavier_normal_(self.fc.weight)
        # nn.init.normal_(self.fc.weight, 0, 0.01)
        nn.init.constant_(self.fc.bias,val=0)

    def forward(self, x, seq_lengths):
        batch_size = x.size(0)
        x = self.embed(x) #[batch, length, embed_size]
        length = x.size(1)
        if length < self.min_len:
            zeros = torch.zeros(batch_size, self.min_len, self.embed_size).to(device)  # for contextualized
            zeros[:, :length, :] = x
            x = zeros
        for i in range(self.depth):
            context, x = self.convs[i](x, seq_lengths)
            seq_lengths = (seq_lengths + 1) /2
        x = F.max_pool1d(x.transpose(1,2),x.size(1)).squeeze(1).transpose(1,2).squeeze(1)
        # out = self.fc(context,x)
        out = self.fc(x)
        return out

# Train the Model
max_accuraries = []
for lr in init_learning_rate:
    tr.epochs = 0
    te.epochs = 0
    current_epochs = 0
    learning_rate = lr
    rnn = DPCNN(embedding_size, context_size, num_classes,filter_size,kernel_size,depth)
    rnn.to(device)
    print(count_parameters(rnn) - count_parameters(rnn.embed))
    # Loss and Optimizer
    criterion = nn.CrossEntropyLoss().to(device)
    optimizer = torch.optim.Adam(rnn.parameters(), lr=learning_rate)
    while tr.epochs < num_epochs:
        t = time.time()
        adjust_learning_rate(optimizer, learning_rate)
        cnt = 0
        while current_epochs == tr.epochs:
            cnt += 1
            pbar = tqdm(range(100))
            loss_eval = 0
            total = 0
            correct = 0
            mse = 0
            for i in pbar:
                optimizer.zero_grad()
                for _ in range(iter_num):
                # training_process
                    x, lengths, labels = tr.next_batch(iter_size)
                    x = torch.from_numpy(x).long().to(device)
                    labels = torch.from_numpy(labels).to(device)
                    lengths = torch.from_numpy(np.array(lengths)).to(device)
                    # Forward + Backward + Optimize
                    outputs = rnn(x,lengths)
                    _, predicted = torch.max(outputs.data, 1)
                    loss = criterion(outputs, labels).to(device)
                    loss_eval += loss.data.item()
                    loss.backward()
                    total += labels.size(0)
                    correct += (predicted == labels).sum()
                    mse += ((predicted - labels)**2).sum()

                torch.nn.utils.clip_grad_norm_(rnn.parameters(), 5.0)
                # torch.nn.utils.clip_grad_value_(rnn.parameters(), 5.0)
                optimizer.step()
                pbar.set_description("accuracy : %f mse : %f loss : %f epoch : %d iter : %d" % (
                100 * float(correct) / float(total),float(mse) / float(total), loss_eval / ((float(i) + 1) * iter_num), (current_epochs + 1),
                cnt))
                if current_epochs < tr.epochs:
                    pbar.close()
                    break
        learning_rate = learning_rate * 0.1
        i = 0
        total = 0
        correct = 0
        mse = 0
        pbar = tqdm()
        while current_epochs == te.epochs:
            for _ in range(iter_num):
                x, lengths, labels = te.next_batch(iter_size//2)
                x = torch.from_numpy(x).long().to(device)
                lengths = torch.from_numpy(np.array(lengths)).to(device)
                labels = torch.from_numpy(labels).to(device)
                outputs = rnn(x,lengths)
                _, predicted = torch.max(outputs.data, 1)
                total += labels.size(0)
                correct += (predicted == labels).sum()
                mse += ((predicted - labels)**2).sum()
            pbar.set_description(
                "test accuracy : %f test MSE : %f time spent %f" % (100 * float(correct) / float(total), float(mse) / float(total), time.time() - t))
        pbar.close()
        acc = 100 * float(correct) / float(total)

        current_epochs += 1
        # print('Test Accuracy %f%%, time spent %f ' %(100*float(correct) / float(total), time.time()-t))
        t = time.time()
# for i in range(num_layers):
#     cell = rnn.lstm.get_cell(i)
#     print(cell.weight_ar.data)
