/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import java.util.regex.Pattern;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.maltparser.core.config.ConfigurationDir;
import org.maltparser.core.config.ConfigurationException;
import org.maltparser.core.config.ConfigurationRegistry;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.helper.SystemLogger;
import org.maltparser.core.helper.Util;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.options.OptionManager;
import org.maltparser.core.propagation.PropagationManager;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.BatchTrainer;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.DeterministicParser;
import org.maltparser.parser.Parser;
import org.maltparser.parser.Trainer;
import org.maltparser.parser.guide.ClassifierGuide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMalt
implements DependencyParserConfig {
    public static final int LEARN = 0;
    public static final int PARSE = 1;
    protected ConfigurationDir configDir;
    protected Logger configLogger;
    protected int optionContainerIndex;
    protected Algorithm parsingAlgorithm = null;
    protected int mode;
    protected ConfigurationRegistry registry;
    protected SymbolTableHandler symbolTableHandler;
    protected long startTime;
    protected long endTime;
    protected int nIterations = 0;
    protected PropagationManager propagationManager;

    public void initialize(int containerIndex, DataFormatInstance dataFormatInstance, ConfigurationDir configDir, int mode) throws MaltChainedException {
        this.optionContainerIndex = containerIndex;
        this.mode = mode;
        this.setConfigurationDir(configDir);
        this.startTime = System.currentTimeMillis();
        this.configLogger = this.initConfigLogger(this.getOptionValue("config", "logfile").toString(), this.getOptionValue("config", "logging").toString());
        this.registry = new ConfigurationRegistry();
        this.symbolTableHandler = dataFormatInstance.getSymbolTables();
        if (mode == 0) {
            this.checkOptionDependency();
        }
        this.registry.put(SymbolTableHandler.class, (Object)this.getSymbolTables());
        this.registry.put(DataFormatInstance.class, (Object)dataFormatInstance);
        this.initPropagation();
        this.initParsingAlgorithm();
    }

    private void initPropagation() throws MaltChainedException {
        String propagationSpecFileName = this.getOptionValue("singlemalt", "propagation").toString();
        if (propagationSpecFileName == null || propagationSpecFileName.length() == 0) {
            return;
        }
        this.propagationManager = new PropagationManager(this.configDir, this.symbolTableHandler);
        if (this.mode == 0) {
            propagationSpecFileName = this.configDir.copyToConfig(propagationSpecFileName);
            OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "singlemalt", "propagation", propagationSpecFileName);
        }
        this.getConfigLogger().info("  Propagation          : " + propagationSpecFileName + "\n");
        this.propagationManager.loadSpecification(propagationSpecFileName);
    }

    protected void initParsingAlgorithm() throws MaltChainedException {
        if (this.mode == 0) {
            this.parsingAlgorithm = new BatchTrainer(this);
        } else if (this.mode == 1) {
            this.parsingAlgorithm = new DeterministicParser(this);
        }
    }

    public void addRegistry(Class<?> clazz, Object o) {
        this.registry.put(clazz, o);
    }

    public void process(Object[] arguments) throws MaltChainedException {
        if (this.mode == 0) {
            if (arguments.length < 2 || !(arguments[0] instanceof DependencyStructure) || !(arguments[1] instanceof DependencyStructure)) {
                throw new MaltChainedException("The single malt learn task must be supplied with at least two dependency structures. ");
            }
            DependencyStructure systemGraph = (DependencyStructure)arguments[0];
            DependencyStructure goldGraph = (DependencyStructure)arguments[1];
            if (systemGraph.hasTokens() && this.getGuide() != null) {
                this.getGuide().finalizeSentence(((Trainer)this.getAlgorithm()).parse(goldGraph, systemGraph));
            }
        } else if (this.mode == 1) {
            if (arguments.length < 1 || !(arguments[0] instanceof DependencyStructure)) {
                throw new MaltChainedException("The single malt parse task must be supplied with at least one input terminal structure and one output dependency structure. ");
            }
            DependencyStructure processGraph = (DependencyStructure)arguments[0];
            if (processGraph.hasTokens()) {
                ((Parser)this.getAlgorithm()).parse(processGraph);
            }
        }
    }

    @Override
    public void parse(DependencyStructure graph) throws MaltChainedException {
        if (graph.hasTokens()) {
            ((Parser)this.getAlgorithm()).parse(graph);
        }
    }

    @Override
    public void oracleParse(DependencyStructure goldGraph, DependencyStructure oracleGraph) throws MaltChainedException {
        if (oracleGraph.hasTokens()) {
            if (this.getGuide() != null) {
                this.getGuide().finalizeSentence(((Trainer)this.getAlgorithm()).parse(goldGraph, oracleGraph));
            } else {
                ((Trainer)this.getAlgorithm()).parse(goldGraph, oracleGraph);
            }
        }
    }

    public void train() throws MaltChainedException {
        if (this.getGuide() == null) {
            ((Trainer)this.getAlgorithm()).train();
        }
    }

    public void terminate(Object[] arguments) throws MaltChainedException {
        this.getAlgorithm().terminate();
        if (this.getGuide() != null) {
            this.getGuide().terminate();
        }
        if (this.mode == 0) {
            this.endTime = System.currentTimeMillis();
            long elapsed = this.endTime - this.startTime;
            if (this.configLogger.isInfoEnabled()) {
                this.configLogger.info("Learning time: " + new Formatter().format("%02d:%02d:%02d", elapsed / 3600000L, elapsed % 3600000L / 60000L, elapsed % 60000L / 1000L) + " (" + elapsed + " ms)\n");
            }
        } else if (this.mode == 1) {
            this.endTime = System.currentTimeMillis();
            long elapsed = this.endTime - this.startTime;
            if (this.configLogger.isInfoEnabled()) {
                this.configLogger.info("Parsing time: " + new Formatter().format("%02d:%02d:%02d", elapsed / 3600000L, elapsed % 3600000L / 60000L, elapsed % 60000L / 1000L) + " (" + elapsed + " ms)\n");
            }
        }
        if (SystemLogger.logger() != this.configLogger && this.configLogger != null) {
            this.configLogger.removeAllAppenders();
        }
    }

    public Logger initConfigLogger(String logfile, String level) throws MaltChainedException {
        if (logfile != null && logfile.length() > 0 && !logfile.equalsIgnoreCase("stdout") && this.configDir != null) {
            this.configLogger = Logger.getLogger(logfile);
            FileAppender fileAppender = null;
            try {
                fileAppender = new FileAppender(new PatternLayout("%m"), this.configDir.getWorkingDirectory().getPath() + File.separator + logfile, true);
            }
            catch (IOException e) {
                throw new ConfigurationException("It is not possible to create a configuration log file. ", e);
            }
            fileAppender.setThreshold(Level.toLevel(level, Level.INFO));
            this.configLogger.addAppender(fileAppender);
            this.configLogger.setLevel(Level.toLevel(level, Level.INFO));
        } else {
            this.configLogger = SystemLogger.logger();
        }
        return this.configLogger;
    }

    @Override
    public Logger getConfigLogger() {
        return this.configLogger;
    }

    @Override
    public void setConfigLogger(Logger logger) {
        this.configLogger = logger;
    }

    @Override
    public ConfigurationDir getConfigurationDir() {
        return this.configDir;
    }

    @Override
    public void setConfigurationDir(ConfigurationDir configDir) {
        this.configDir = configDir;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public ConfigurationRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ConfigurationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Object getOptionValue(String optiongroup, String optionname) throws MaltChainedException {
        return OptionManager.instance().getOptionValue(this.optionContainerIndex, optiongroup, optionname);
    }

    @Override
    public String getOptionValueString(String optiongroup, String optionname) throws MaltChainedException {
        return OptionManager.instance().getOptionValueString(this.optionContainerIndex, optiongroup, optionname);
    }

    public OptionManager getOptionManager() throws MaltChainedException {
        return OptionManager.instance();
    }

    @Override
    public SymbolTableHandler getSymbolTables() {
        return this.symbolTableHandler;
    }

    @Override
    public PropagationManager getPropagationManager() {
        return this.propagationManager;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.parsingAlgorithm;
    }

    @Override
    public ClassifierGuide getGuide() {
        return this.parsingAlgorithm.getGuide();
    }

    public void checkOptionDependency() throws MaltChainedException {
        try {
            String featureModelFileName;
            if (this.configDir.getInfoFileWriter() != null) {
                this.configDir.getInfoFileWriter().write("\nDEPENDENCIES\n");
            }
            if ((featureModelFileName = this.getOptionValue("guide", "features").toString().trim()).equals("")) {
                OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "guide", "features", this.getOptionValueString("singlemalt", "parsing_algorithm"));
                featureModelFileName = this.getOptionValue("guide", "features").toString().trim();
                featureModelFileName = featureModelFileName.replace("{learner}", this.getOptionValueString("guide", "learner"));
                featureModelFileName = this.configDir.copyToConfig(Util.findURLinJars(featureModelFileName));
            } else {
                featureModelFileName = this.configDir.copyToConfig(featureModelFileName);
            }
            OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "guide", "features", featureModelFileName);
            if (this.configDir.getInfoFileWriter() != null) {
                this.configDir.getInfoFileWriter().write("--guide-features (  -F)                 " + this.getOptionValue("guide", "features").toString() + "\n");
            }
            if (this.getOptionValue("guide", "data_split_column").toString().equals("") && !this.getOptionValue("guide", "data_split_structure").toString().equals("")) {
                this.configLogger.warn("Option --guide-data_split_column = '' and --guide-data_split_structure != ''. Option --guide-data_split_structure is overloaded with '', this will cause the parser to induce a single model.\n ");
                OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "guide", "data_split_structure", "");
                if (this.configDir.getInfoFileWriter() != null) {
                    this.configDir.getInfoFileWriter().write("--guide-data_split_structure (  -s)\n");
                }
            }
            if (!this.getOptionValue("guide", "data_split_column").toString().equals("") && this.getOptionValue("guide", "data_split_structure").toString().equals("")) {
                this.configLogger.warn("Option --guide-data_split_column != '' and --guide-data_split_structure = ''. Option --guide-data_split_column is overloaded with '', this will cause the parser to induce a single model.\n");
                OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "guide", "data_split_column", "");
                if (this.configDir.getInfoFileWriter() != null) {
                    this.configDir.getInfoFileWriter().write("--guide-data_split_column (  -d)\n");
                }
            }
            String decisionSettings = this.getOptionValue("guide", "decision_settings").toString().trim();
            String markingStrategy = this.getOptionValue("pproj", "marking_strategy").toString().trim();
            String coveredRoot = this.getOptionValue("pproj", "covered_root").toString().trim();
            StringBuilder newDecisionSettings = new StringBuilder();
            decisionSettings = decisionSettings == null || decisionSettings.length() < 1 || decisionSettings.equals("default") ? "T.TRANS+A.DEPREL" : decisionSettings.toUpperCase();
            if ((markingStrategy.equalsIgnoreCase("head") || markingStrategy.equalsIgnoreCase("path") || markingStrategy.equalsIgnoreCase("head+path")) && !Pattern.matches(".*A\\.PPLIFTED.*", decisionSettings)) {
                newDecisionSettings.append("+A.PPLIFTED");
            }
            if ((markingStrategy.equalsIgnoreCase("path") || markingStrategy.equalsIgnoreCase("head+path")) && !Pattern.matches(".*A\\.PPPATH.*", decisionSettings)) {
                newDecisionSettings.append("+A.PPPATH");
            }
            if (!coveredRoot.equalsIgnoreCase("none") && !Pattern.matches(".*A\\.PPCOVERED.*", decisionSettings)) {
                newDecisionSettings.append("+A.PPCOVERED");
            }
            if (!this.getOptionValue("guide", "decision_settings").toString().equals(decisionSettings) || newDecisionSettings.length() > 0) {
                OptionManager.instance().overloadOptionValue(this.optionContainerIndex, "guide", "decision_settings", decisionSettings + newDecisionSettings.toString());
                if (this.configDir.getInfoFileWriter() != null) {
                    this.configDir.getInfoFileWriter().write("--guide-decision_settings (  -gds)                 " + this.getOptionValue("guide", "decision_settings").toString() + "\n");
                }
            }
            if (this.configDir.getInfoFileWriter() != null) {
                this.configDir.getInfoFileWriter().flush();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not write to the configuration information file. ", e);
        }
    }
}

