/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractMatrix;
import java.util.Arrays;

public class DenseMatrix
extends AbstractMatrix {
    private final double[][] mValues;
    private final int mNumRows;
    private final int mNumColumns;
    private static final boolean IGNORE = true;

    public DenseMatrix(int numRows, int numColumns) {
        this(DenseMatrix.zeroValues(numRows, numColumns), true);
    }

    public DenseMatrix(double[][] values) {
        this(DenseMatrix.copyValues(values), true);
    }

    DenseMatrix(double[][] values, boolean ignoreMe) {
        this.mValues = values;
        this.mNumRows = values.length;
        if (this.mNumRows < 1) {
            String msg = "Require positive number of rows. Found number of rows=" + this.mNumRows;
            throw new IllegalArgumentException(msg);
        }
        this.mNumColumns = values[0].length;
        if (this.mNumColumns < 1) {
            String msg = "Require positive number of columns. Found number of columns=" + this.mNumColumns;
            throw new IllegalArgumentException(msg);
        }
    }

    public final int numRows() {
        return this.mNumRows;
    }

    public final int numColumns() {
        return this.mNumColumns;
    }

    public double value(int row, int column) {
        return this.mValues[row][column];
    }

    public void setValue(int row, int column, double value) {
        this.mValues[row][column] = value;
    }

    private static int numColumns(double[][] values) {
        int numColumns = 0;
        for (int i = 0; i < values.length; ++i) {
            numColumns = Math.max(numColumns, values[i].length);
        }
        return numColumns;
    }

    private static double[][] copyValues(double[][] values) {
        int numRows = values.length;
        int numColumns = DenseMatrix.numColumns(values);
        double[][] result = new double[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            int j;
            for (j = 0; j < values[i].length; ++j) {
                result[i][j] = values[i][j];
            }
            for (j = values[i].length; j < numColumns; ++j) {
                result[i][j] = 0.0;
            }
        }
        return result;
    }

    private static double[][] zeroValues(int numRows, int numColumns) {
        double[][] result = new double[numRows][numColumns];
        for (int i = 0; i < result.length; ++i) {
            Arrays.fill(result[i], 0.0);
        }
        return result;
    }
}

