/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.io.LogLevel;
import com.aliasi.io.PrintWriterReporter;
import com.aliasi.io.Reporter;
import com.aliasi.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;

public class Reporters {
    static final Reporter SILENT_REPORTER = new Reporter(LogLevel.NONE){

        public void report(LogLevel level, String msg) {
        }

        public void close() {
        }
    };

    private Reporters() {
    }

    public static Reporter writer(Writer writer) {
        return new PrintWriterReporter(new PrintWriter(writer));
    }

    public static Reporter stream(OutputStream out, String encoding) throws UnsupportedCharsetException {
        try {
            return Reporters.writer(new OutputStreamWriter(out, encoding));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Encoding=" + encoding + " Base exception=" + e;
            throw new UnsupportedCharsetException(msg);
        }
    }

    public static Reporter file(File f, String encoding) throws IOException {
        return Reporters.stream(new FileOutputStream(f), encoding);
    }

    public static Reporter stdOut() {
        return Reporters.stream(System.out, Strings.UTF8);
    }

    public static Reporter tee(Reporter ... reporters) {
        return new TeeReporter(reporters);
    }

    public static Reporter silent() {
        return SILENT_REPORTER;
    }

    static final class TeeReporter
    extends Reporter {
        final Reporter[] mReporters;

        public TeeReporter(Reporter[] reporters) {
            this.mReporters = reporters;
        }

        public void report(LogLevel level, String msg) {
            if (!this.isEnabled(level)) {
                return;
            }
            for (Reporter reporter : this.mReporters) {
                reporter.report(level, msg);
            }
        }

        public void close() {
            for (Reporter rep : this.mReporters) {
                rep.close();
            }
        }
    }
}

