/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import tsg.LTSG.NodeStructure;
import tsg.TSNode;

class LexTreeStructure {
    TSNode anchor;
    TSNode lexTreeCopy;
    List<TSNode> subSites;
    double lexTreeLogProb;
    Double bestDerivationLogProb;
    Double insideLogProbTree;
    boolean computedInsidedLogProbTree;

    public LexTreeStructure(TSNode anchor, TSNode lexTreeCopy, double lexTreeLogProb) {
        this.anchor = anchor;
        this.lexTreeCopy = lexTreeCopy;
        this.lexTreeLogProb = lexTreeLogProb;
        this.subSites = new ArrayList<TSNode>();
        this.computedInsidedLogProbTree = false;
    }

    public LexTreeStructure(TSNode anchor, TSNode lexTreeCopy, double lexTreeLogProb, List<TSNode> subSites) {
        this.anchor = anchor;
        this.lexTreeCopy = lexTreeCopy;
        this.lexTreeLogProb = lexTreeLogProb;
        this.subSites = subSites;
        this.computedInsidedLogProbTree = false;
    }

    public Double getInsideLogProbTree(IdentityHashMap<TSNode, NodeStructure> bestDerivationTable) {
        if (!this.computedInsidedLogProbTree) {
            this.insideLogProbTree = this.lexTreeLogProb;
            this.bestDerivationLogProb = this.lexTreeLogProb;
            for (TSNode S : this.subSites) {
                NodeStructure strucureS = bestDerivationTable.get(S);
                if (strucureS == null) {
                    this.bestDerivationLogProb = null;
                    return null;
                }
                this.bestDerivationLogProb = this.bestDerivationLogProb + strucureS.getBestLexTree().bestDerivationLogProb;
                this.insideLogProbTree = this.insideLogProbTree + strucureS.insideLogProb;
            }
        }
        this.computedInsidedLogProbTree = true;
        return this.insideLogProbTree;
    }

    public Double getInsideLogProbTreeExludingSubSite(IdentityHashMap<TSNode, NodeStructure> bestDerivationTable, TSNode subSiteToExclude) {
        double result = this.lexTreeLogProb;
        for (TSNode S : this.subSites) {
            if (S == subSiteToExclude) continue;
            NodeStructure strucureS = bestDerivationTable.get(S);
            if (strucureS == null) {
                return null;
            }
            result += strucureS.insideLogProb;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.lexTreeCopy.toString(false, true)) + ": " + this.bestDerivationLogProb;
    }
}

