/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import tsg.Constituency;
import tsg.ConstituencyYield;
import tsg.TSNodeLabel;
import tsg.Yield;
import util.Utility;

public class ConstituencyChars
extends Constituency {
    int initialIndex;
    int finalIndex;

    public ConstituencyChars(TSNodeLabel node, int initialIndex, int finalIndex, boolean countLabel) {
        super(node, countLabel);
        this.initialIndex = initialIndex;
        this.finalIndex = finalIndex;
    }

    @Override
    public Constituency unlabeledCopy() {
        return new ConstituencyChars(this.node, this.initialIndex, this.finalIndex, false);
    }

    public static ArrayList<Constituency> collectConsituencies(TSNodeLabel tree, boolean labeled, String[] excludeLabels, boolean includePos) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        IdentityHashMap<TSNodeLabel, int[]> lexicalCharSpans = new IdentityHashMap<TSNodeLabel, int[]>();
        ArrayList<TSNodeLabel> lexicalNodes = tree.collectLexicalItems();
        int charCount = 0;
        int i = 0;
        while (i < lexicalNodes.size()) {
            TSNodeLabel LN = (TSNodeLabel)lexicalNodes.get(i);
            String label = LN.label();
            label = label.replaceAll("\\s+", "");
            int startCharIndex = ++charCount;
            int endCharIndex = charCount = startCharIndex + label.length() - 1;
            lexicalCharSpans.put(LN, new int[]{startCharIndex, endCharIndex});
            ++i;
        }
        ArrayList<TSNodeLabel> internalNodes = tree.collectAllNodes();
        for (TSNodeLabel NT : internalNodes) {
            if (NT.isLexical || NT.isPreLexical() && !includePos || Arrays.binarySearch(excludeLabels, NT.label()) >= 0) continue;
            int[] charSpanStartWord = (int[])lexicalCharSpans.get(NT.getLeftmostLexicon());
            int[] charSpanEndWord = (int[])lexicalCharSpans.get(NT.getRightmostLexicon());
            result.add(new ConstituencyChars(NT, charSpanStartWord[0], charSpanEndWord[1], labeled));
        }
        return result;
    }

    public boolean isCrossing(ConstituencyChars c) {
        return this.initialIndex < c.initialIndex && this.finalIndex >= c.initialIndex && this.finalIndex < c.finalIndex || this.initialIndex > c.initialIndex && this.initialIndex <= c.finalIndex && this.finalIndex > c.finalIndex;
    }

    public static int updateCrossingBrackets(List<Constituency> testConst, List<Constituency> goldConst, Hashtable<String, Integer> crossingBracketsCatTable) {
        int result = 0;
        block0: for (Constituency testC : testConst) {
            for (Constituency goldC : goldConst) {
                if (!((ConstituencyChars)testC).isCrossing((ConstituencyChars)goldC)) continue;
                ++result;
                if (crossingBracketsCatTable == null) continue block0;
                String key = String.valueOf(testC.node.label()) + "/" + goldC.node.label();
                Utility.increaseStringInteger(crossingBracketsCatTable, key, 1);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ConstituencyChars) {
            ConstituencyChars c = (ConstituencyChars)anObject;
            if ((!this.countLabel || c.node.sameLabel(this.node)) && c.initialIndex == this.initialIndex && c.finalIndex == this.finalIndex) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.countLabel) {
            return 31 * (this.initialIndex + 31 * (this.finalIndex + 31 * this.label().hashCode()));
        }
        return 31 * (this.initialIndex + 31 * this.finalIndex);
    }

    public static List<Constituency> toYieldConstituency(List<Constituency> list, TSNodeLabel tree, boolean labeled) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        ArrayList<TSNodeLabel> lexicon = tree.collectLexicalItems();
        for (Constituency C : list) {
            ConstituencyChars IC = (ConstituencyChars)C;
            List subLex = lexicon.subList(IC.initialIndex, IC.finalIndex + 1);
            String yield = "";
            for (TSNodeLabel lex : subLex) {
                yield = String.valueOf(yield) + lex + " ";
            }
            yield = yield.trim();
            result.add(new ConstituencyYield(IC.node, new Yield(yield), labeled));
        }
        return result;
    }

    public String toString() {
        return "(" + this.node.label() + ": " + this.initialIndex + "-" + this.finalIndex + ")";
    }

    public static void main(String[] args) throws Exception {
        TSNodeLabel goldTree = new TSNodeLabel("(S (A (P this)) (B (Q1 is) (Q2 n't)) (A (R easy)))");
        TSNodeLabel testTree = new TSNodeLabel("(S (A (P this)) (B (Q isn't)) (A (R easy))))");
        ArrayList<Constituency> goldConsts = ConstituencyChars.collectConsituencies(goldTree, true, new String[0], false);
        ArrayList<Constituency> testConsts = ConstituencyChars.collectConsituencies(testTree, true, new String[0], false);
        System.out.println(((Object)goldConsts).toString());
        System.out.println(((Object)testConsts).toString());
    }
}

