/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;

public class TSGparsingBitParDirect
extends TSGparsingBitPar {
    public TSGparsingBitParDirect(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
    }

    @Override
    public String getClassName() {
        return "TSGparsingBitParDirect";
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        int sentencesPerThreads = this.testSize / threads;
        int remainingSentences = this.testSize % threads;
        ArrayList<String[]> testSentencesWords = TSGparsingBitParDirect.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = TSGparsingBitParDirect.getSentencesWords(this.originalTestTreebank);
        BitParThreadRunner[] bitParThreadArray = new BitParThreadRunner[threads];
        int reachedIndex = 0;
        int i = 0;
        while (i < threads) {
            int threadIndex = i + 1;
            int sentencesThreads = sentencesPerThreads;
            if (i < remainingSentences) {
                ++sentencesThreads;
            }
            int startingIndex = reachedIndex;
            ArrayList<String[]> testSentencesWordsThread = new ArrayList<String[]>(testSentencesWords.subList(startingIndex, reachedIndex += sentencesThreads));
            ArrayList<String[]> originalTestSentencesWordsThread = null;
            originalTestSentencesWordsThread = new ArrayList<String[]>(originalSentencesWords.subList(startingIndex, reachedIndex));
            bitParThreadArray[i] = new BitParThreadRunner(threadIndex, startingIndex, testSentencesWordsThread, originalTestSentencesWordsThread);
            ++i;
        }
        this.submitMultithreadJob(bitParThreadArray);
        this.parsedOutputFiles = bitParThreadArray[0].metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = bitParThreadArray[0].metricOptimizer.getIdentifiers();
        BitParThreadRunner[] bitParThreadRunnerArray = bitParThreadArray;
        int n = bitParThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitParThreadRunner t = bitParThreadRunnerArray[n2];
            t.metricOptimizer.appendResult(this.parsedOutputFiles);
            ++n2;
        }
        Parameters.reportLineFlush("Finished Parsing.");
    }

    private void submitMultithreadJob(BitParThreadRunner[] bitParThreadArray) {
        int i = 0;
        while (i < threads - 1) {
            BitParThreadRunner t = bitParThreadArray[i];
            t.start();
            ++i;
        }
        bitParThreadArray[threads - 1].run();
        i = 0;
        while (i < threads - 1) {
            try {
                bitParThreadArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }

    protected class BitParThreadRunner
    extends Thread {
        int threadIndex;
        int startSentenceIndex;
        ArrayList<String[]> flatSentencesForBitPar;
        ArrayList<String[]> originalTestSentencesWordsThread;
        MetricOptimizerArray metricOptimizer;

        public BitParThreadRunner(int threadIndex, int startSentenceIndex, ArrayList<String[]> testSentencesWordsThread, ArrayList<String[]> originalTestSentencesWordsThread) {
            this.threadIndex = threadIndex;
            this.startSentenceIndex = startSentenceIndex;
            this.flatSentencesForBitPar = testSentencesWordsThread;
            this.originalTestSentencesWordsThread = originalTestSentencesWordsThread;
            this.metricOptimizer = new MetricOptimizerArray();
        }

        @Override
        public void run() {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(bitparCommandAndArgs);
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                ReadInputStream inputStandardThread = new ReadInputStream(inputStd);
                ReadErrorStream inputErrorThread = new ReadErrorStream(inputErr);
                inputStandardThread.start();
                inputErrorThread.start();
                Iterator<String[]> iterator = this.flatSentencesForBitPar.iterator();
                while (iterator.hasNext()) {
                    String[] flatSentence;
                    String[] stringArray = flatSentence = iterator.next();
                    int n = flatSentence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String word = stringArray[n2];
                        output.write(String.valueOf(word) + "\n");
                        ++n2;
                    }
                    output.write("\n");
                    output.flush();
                }
                output.write("\n");
                output.flush();
                output.close();
                inputStandardThread.join();
                inputErrorThread.join();
                inputStd.close();
                inputErr.close();
            }
            catch (Exception err) {
                err.printStackTrace();
                Parameters.reportLineFlush(err.getMessage());
                return;
            }
        }

        protected class ReadErrorStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;
            int currentSentenceIndex;
            float parsingTime;
            int sentenceCounter;

            public ReadErrorStream(BufferedReader input) {
                this.currentSentenceIndex = BitParThreadRunner.this.startSentenceIndex;
                this.input = input;
                this.reportPrefix = "[stdOutErr_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        if (line.equals("")) continue;
                        if (Character.isDigit(line.charAt(0))) {
                            TSGparsingBitParDirect.this.doneWithOneSentence();
                            continue;
                        }
                        if (line.startsWith("reading") || line.startsWith("parameter") || line.startsWith("finished") || line.startsWith("raw")) continue;
                        Parameters.reportLineFlush(String.valueOf(this.reportPrefix) + line);
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush(err.getMessage());
                    return;
                }
            }
        }

        protected class ReadInputStream
        extends Thread {
            BufferedReader input;
            Iterator<String[]> originalTestIterator = null;
            String[] originalTestSentenceWords = null;
            double lastReadProb;
            int completedSentences;

            public ReadInputStream(BufferedReader input) {
                this.input = input;
                this.originalTestIterator = BitParThreadRunner.this.originalTestSentencesWordsThread.iterator();
                this.originalTestSentenceWords = this.originalTestIterator.next();
                BitParThreadRunner.this.metricOptimizer.prepareNextSentence(this.originalTestSentenceWords);
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        this.processLine(line);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush(err.getMessage());
                    return;
                }
            }

            private void processLine(String line) throws Exception {
                if (line.equals("")) {
                    BitParThreadRunner.this.metricOptimizer.storeCurrentBestParseTrees();
                    if (this.originalTestIterator.hasNext()) {
                        this.originalTestSentenceWords = this.originalTestIterator.next();
                        BitParThreadRunner.this.metricOptimizer.prepareNextSentence(this.originalTestSentenceWords);
                    }
                    return;
                }
                if (line.charAt(0) == '(') {
                    TSNodeLabel tree = null;
                    line = line.replaceAll("\\\\", "");
                    try {
                        tree = new TSNodeLabel(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tree = TSGparsingBitParDirect.this.postProcessParseTree(tree);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                if (line.startsWith("vitprob=")) {
                    this.lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                    return;
                }
                if (line.startsWith("No parse for: ")) {
                    TSNodeLabel tree = TSGparsingBitParDirect.this.dealWithNOParsedSentences(this.originalTestSentenceWords);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                Parameters.reportLineFlush("Unknown line in bitpar output: " + line);
            }
        }
    }
}

