# Some necessary packages

import numpy as np
import pandas as pd

import transformers
import torch
from torch import nn
import random
import gpustat
print(transformers.__version__)
print(torch.__version__)
print(torch.cuda.is_available())

from IPython.display import display, HTML

import re
from sklearn.model_selection import train_test_split
import datasets
from datasets import Dataset, DatasetDict
from transformers import DebertaV2Tokenizer, DebertaV2Model, DebertaV2ForSequenceClassification, TrainingArguments, Trainer, get_cosine_schedule_with_warmup, AdamW
from sklearn.metrics import f1_score, classification_report, accuracy_score
from sklearn.model_selection import ParameterGrid
import joblib
from scipy import stats
import json

import wandb
wandb.init(project='SHROOM-deberta-train')


task = "mnli"

# Checkpoints for loading models
model_checkpoint = "/deberta-v3-large-zeroshot-v1.1-all-33"
# model_checkpoint = "deberta-v3-base-zeroshot-v1.1-all-33"

# model_checkpoint = "deberta-v3-base-finetuned/checkpoint-1200"
# model_checkpoint = "Models/vectara_hallucination_evaluation_model"

# The output path of the trained model
output_path = 'output/'



device = torch.device('cuda:0' if torch.cuda.is_available() else 'cpu')


def print_gpu_info():
    if device == 'cpu':
        return 
    stats = gpustat.GPUStatCollection.new_query()
    for gpu in stats:
        print('GPU ID: {}'.format(gpu.index))
        print('Used Memory: {}/{}'.format(gpu.memory_used, gpu.memory_total))


# Set random seeds to ensure reproducibility
def set_seeds(seed):
    random.seed(seed)  # Set the seed for the random module to ensure consistent results
    np.random.seed(seed)  # Ensure that random numbers generated by the numpy module are consistent
    torch.manual_seed(seed)  # Set the random seed for the CPU (PyTorch)
    if torch.cuda.is_available():  # Check if CUDA (GPU) is available
        torch.cuda.manual_seed(seed)  # Set the seed for the current GPU
        torch.cuda.manual_seed_all(seed)  # Set the seed for all available GPUs

    torch.backends.cudnn.deterministic = True  # Ensure deterministic behavior of the network (fixed network structure)

set_seeds(42)


def show_random_elements(dataset, num_examples=10):
    assert num_examples <= len(dataset), "Can't pick more elements than there are in the dataset."
    picks = []
    for _ in range(num_examples):
        pick = random.randint(0, len(dataset)-1)
        while pick in picks:
            pick = random.randint(0, len(dataset)-1)
        picks.append(pick)

    df = pd.DataFrame(dataset[picks])
    for column, typ in dataset.features.items():
        if isinstance(typ, datasets.ClassLabel):
            df[column] = df[column].transform(lambda i: typ.names[i])
    display(HTML(df.to_html()))



task_to_keys = {
    "mnli": ("premise", "hypothesis")
}



# Loads a pre-trained DeBERTa-v2 tokenizer from the specified model checkpoint.
tokenizer = DebertaV2Tokenizer.from_pretrained(model_checkpoint)

def preprocess_function(examples):
    if sentence2_key is None:
        return tokenizer(examples[sentence1_key], truncation=True, max_length=256, padding='max_length')
    return tokenizer(examples[sentence1_key], examples[sentence2_key], truncation=True, max_length=256, padding='max_length')




for task_cf in ['DM', 'MT', 'PG']:

    val_data1 = pd.read_json('data/val.model-agnostic.json')
    val_data2 = pd.read_json('data/val.model-aware.v2.json')
    val_data = pd.concat([val_data1, val_data2], axis=0, ignore_index=True)
    # Model building by task
    # ************************
    val_data = val_data[val_data['task']==task_cf]
    val_data.index = np.arange(val_data.shape[0])
    # ************************
    # For rows where the task is 'DM' or 'MT', copy the 'tgt' column to itself (no changes), later we will use the tgt column as the ref column.
    val_data.loc[val_data['task'].isin(['DM', 'MT']), 'tgt'] = val_data['tgt']
    # For rows where the task is 'PG', copy the 'src' column to the 'tgt' column, later we will use the tgt column as the ref column.
    val_data.loc[val_data['task']=='PG', 'tgt'] = val_data['src']
    val_data=val_data[['tgt','hyp','label']]
    val_data.columns=['tgt','hyp','label']



    val_data['label'].replace('Hallucination',1,inplace=True)
    val_data['label'].replace('Not Hallucination',0,inplace=True)
    val_data.columns=['tgt','hyp','label']


    # Load the test data
    test_data_agnostic = pd.read_json('data/test.model-agnostic.json')
    test_data_agnostic['label'] = 0
    test_data_agnostic.loc[test_data_agnostic['task'].isin(['DM', 'MT']), 'tgt'] = test_data_agnostic['tgt']
    test_data_agnostic.loc[test_data_agnostic['task']=='PG', 'tgt'] = test_data_agnostic['src']
    test_data_agnostic = test_data_agnostic[['tgt','hyp','label']]
    test_data_agnostic.columns=['tgt','hyp','label']


    test_data_aware = pd.read_json('data/test.model-aware.json')
    test_data_aware['label'] = 0
    test_data_aware.loc[test_data_aware['task'].isin(['DM', 'MT']), 'tgt'] = test_data_aware['tgt']
    test_data_aware.loc[test_data_aware['task']=='PG', 'tgt'] = test_data_aware['src']
    test_data_aware = test_data_aware[['tgt','hyp','label']]
    
    test_data_agnostic_all = pd.read_json('data/test.model-agnostic.json')
    test_data_aware_all = pd.read_json('data/test.model-aware.json')



    # Process text
    # We do not perform special treatment

    def clearTextFunc(text):
        # clear_text = " ".join(text.split())
        # clear_text = re.sub(r'http://[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
        # clear_text = re.sub(r'https://[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
        # clear_text = re.sub(r'@[a-zA-Z0-9.?/&=:]*'," ",  clear_text)
        # clear_text = re.sub(r'/s'," ",  clear_text)
        # clear_text = re.sub(r'/j'," ",  clear_text)
        # clear_text  = clear_text.lower()

        return text

    def clearTexts(data,pos='tweet'):
        # Get the number of Texts based on the dataframe column size
        global num_Texts
        num_Texts = data[pos].size
        # Initialize an empty list to hold the clean Texts
        print("Cleaning and parsing the training set Texts...\n")
        # Loop over each Text; create an index i that goes from 0 to the length# of the Text list
        for i in range( 0, num_Texts ):
            # If the index is evenly divisible by 1000, print a message
            if( (i+1)%100000 == 0 ):
                print("Text %d of %d\n" % ( i+1, num_Texts ))
            # Call our function for each one, and add the result to the list of    # clean Texts
            if(str(data[pos][i])!="nan"):
                clean_train_Texts.append( clearTextFunc( data[pos][i] ) )
            else:
                clean_train_Texts.append( clearTextFunc("" ) )


    # training set
    clean_train_Texts = []
    num_Texts = 0
    clearTexts(val_data,pos='tgt')
    clean_train_Texts_tgt = clean_train_Texts
    num_Texts_tgt = num_Texts

    clean_train_Texts = []
    num_Texts = 0
    clearTexts(val_data,pos='hyp')
    clean_train_Texts_hyp = clean_train_Texts
    num_Texts_hyp = num_Texts

    label_text = val_data['label']
    label_text=np.array(label_text)
    label_text = label_text.reshape(num_Texts_tgt,1)
    print(label_text.shape)

    # Partition the data set
    train_tgt=clean_train_Texts_tgt
    train_hyp=clean_train_Texts_hyp
    train_label=label_text


    # test set 1
    clean_train_Texts = []
    num_Texts = 0
    clearTexts(test_data_agnostic,pos='tgt')
    clean_train_Texts_tgt = clean_train_Texts
    num_Texts_tgt = num_Texts

    clean_train_Texts = []
    num_Texts = 0
    clearTexts(test_data_agnostic,pos='hyp')
    clean_train_Texts_hyp = clean_train_Texts
    num_Texts_hyp = num_Texts

    label_text = test_data_agnostic['label']
    label_text=np.array(label_text)
    label_text = label_text.reshape(num_Texts_tgt,1)
    print(label_text.shape)

    # Partition the data set
    test_data_agnostic_tgt=clean_train_Texts_tgt
    test_data_agnostic_hyp=clean_train_Texts_hyp
    test_data_agnostic_l=label_text


    # test set 2
    clean_train_Texts = []
    num_Texts = 0
    clearTexts(test_data_aware,pos='tgt')
    clean_train_Texts_tgt = clean_train_Texts
    num_Texts_tgt = num_Texts

    clean_train_Texts = []
    num_Texts = 0
    clearTexts(test_data_aware,pos='hyp')
    clean_train_Texts_hyp = clean_train_Texts
    num_Texts_hyp = num_Texts

    label_text = test_data_aware['label']
    label_text=np.array(label_text)
    label_text = label_text.reshape(num_Texts_tgt,1)
    print(label_text.shape)

    # Partition the data set
    test_data_aware_tgt=clean_train_Texts_tgt
    test_data_aware_hyp=clean_train_Texts_hyp
    test_data_aware_l=label_text

    


    from sklearn.model_selection import KFold
    kf = KFold(n_splits=5, shuffle=True, random_state=42)
    for fold, (train_index, val_index) in enumerate(kf.split(train_tgt)):
        train_En_X, val_En_X = np.array(train_tgt)[train_index], np.array(train_tgt)[val_index]
        train_Ar_X, val_Ar_X = np.array(train_hyp)[train_index], np.array(train_hyp)[val_index]
        train_l_En_X, val_l_En_X = np.array(train_label)[train_index], np.array(train_label)[val_index]

        dataset_all = DatasetDict({'train':Dataset.from_dict({"premise": train_En_X,"hypothesis": train_Ar_X,'label':train_l_En_X.reshape(-1)}),
                            'dev':Dataset.from_dict({"premise": val_En_X,"hypothesis": val_Ar_X,'label':val_l_En_X.reshape(-1)}),
                            'test1':Dataset.from_dict({"premise": test_data_agnostic_tgt,"hypothesis": test_data_agnostic_hyp,'label':test_data_agnostic_l.reshape(-1)}),
                            'test2':Dataset.from_dict({"premise": test_data_aware_tgt,"hypothesis": test_data_aware_hyp,'label':test_data_aware_l.reshape(-1)})})



        sentence1_key, sentence2_key = task_to_keys[task]
        encoded_dataset_En = dataset_all.map(preprocess_function, batched=True)

        num_labels = 2

        metric_name = "accuracy"
        model_name = model_checkpoint.split("/")[-1]



        # evaluation function
        def compute_metrics1(eval_pred):
            y_pred, y_true = eval_pred
            y_pred = np.argmax(y_pred, axis=1)
            F1 = f1_score(y_true, y_pred,labels=[0,1])
            acc = accuracy_score(y_true, y_pred)
            return{'f1-score': F1,'accuracy': acc}

        from torch.nn import CrossEntropyLoss
        class CustomTrainer(Trainer):
            def create_optimizer_and_scheduler(self, num_training_steps: int):
                self.optimizer = AdamW(self.model.parameters(), lr=self.args.learning_rate)
                self.lr_scheduler = get_cosine_schedule_with_warmup(self.optimizer, num_warmup_steps=self.args.warmup_steps, num_training_steps=num_training_steps)
            


        param_grid = {
                'learning_rate': [3e-5],
                'per_device_train_batch_size': [8],
                'per_device_eval_batch_size': [64],
                'weight_decay': [0.1],
                'gradient_accumulation_steps':[8]
        }


        print_gpu_info()

        grid = ParameterGrid(param_grid)

        best_metric = float('-inf')
        best_model = None
        best_params = None

        for params in grid: 

            train_dataset = encoded_dataset_En["train"]
            val_dataset = encoded_dataset_En["dev"]

            # model
            model1 = DebertaV2ForSequenceClassification.from_pretrained(model_checkpoint, 
                                                                        num_labels=num_labels)#,
                                                                        # hidden_dropout_prob=0.1,  # dropout
                                                                        # attention_probs_dropout_prob=0.1)  # dropout)
            

            model1.to(device)

            # Create new training parameters
            args = TrainingArguments(
                output_dir=f"/gm-data/{output_path}{model_name}-finetuned",
                overwrite_output_dir=True, # Automatically overwrite files under output_dir
                evaluation_strategy = "steps",
                save_strategy = "steps",
                num_train_epochs=3,
                load_best_model_at_end=True,
                metric_for_best_model=metric_name,
                logging_steps=3, # How many steps to evaluate
                save_steps=3, # How many steps to save
                save_total_limit=1, # Only save n models
                adam_beta1=0.9,
                adam_beta2=0.95,
                warmup_steps=3, # number of warmup steps
                # max_grad_norm=0.9, # Gradient clipping
                **params
            )


            # Create a new trainer instance
            trainer = CustomTrainer(
                model1,
                args,
                train_dataset=train_dataset,
                eval_dataset=val_dataset,
                tokenizer=tokenizer,
                compute_metrics=compute_metrics1,
            )


            trainer.train()

            print_gpu_info()

            trainer.evaluate()


            # Test set 1 output results
            pred = trainer.predict(encoded_dataset_En["test1"])

            test_data_agnostic_all['label'] = np.argmax(pred[0], axis=1).tolist()

            exp_logits = np.exp(pred[0] - np.max(pred[0], axis=1, keepdims=True))
            probabilities = exp_logits / np.sum(exp_logits, axis=1, keepdims=True)
            test_data_agnostic_all['p(Hallucination)'] = probabilities[:, 1]

            if fold==0:
                mask = test_data_agnostic_all['task'] == task_cf
                test_data_agnostic_all.loc[mask, 'p(Hallucination)'] = probabilities[:, 1][mask]
            else:
                mask = test_data_agnostic_all['task'] == task_cf
                test_data_agnostic_all.loc[mask, 'p(Hallucination)'] = (test_data_agnostic_all.loc[mask, 'p(Hallucination)']*fold + probabilities[:, 1][mask])/(fold+1)


            # Test set 1 output results
            pred = trainer.predict(encoded_dataset_En["test2"])

            test_data_aware_all['label'] = np.argmax(pred[0], axis=1).tolist()

            exp_logits = np.exp(pred[0] - np.max(pred[0], axis=1, keepdims=True))
            probabilities = exp_logits / np.sum(exp_logits, axis=1, keepdims=True)
            test_data_aware_all['p(Hallucination)'] = probabilities[:, 1]


            if fold==0:
                mask = test_data_aware_all['task'] == task_cf
                test_data_aware_all.loc[mask, 'p(Hallucination)'] = probabilities[:, 1][mask]
            else:
                mask = test_data_aware_all['task'] == task_cf
                test_data_aware_all.loc[mask, 'p(Hallucination)'] = (test_data_aware_all.loc[mask, 'p(Hallucination)']*fold + probabilities[:, 1][mask])/(fold+1)




test_data_agnostic_all.loc[:, 'label'] = (test_data_agnostic_all['p(Hallucination)']>=0.5).astype(int)
path_val_model_aware_output = "test.model-agnostic.json" 
output_json = []
for i in np.arange(test_data_agnostic_all.shape[0]):
    output_label = 'Hallucination' if test_data_agnostic_all.loc[i,'label'] == 1 else 'Not Hallucination'
    prob=test_data_agnostic_all.loc[i,'p(Hallucination)']
    id=test_data_agnostic_all.loc[i,'id']
    item_to_json = {"label":output_label, "p(Hallucination)":np.float64(prob), "id":int(id)}
    output_json.append(item_to_json)
f = open(path_val_model_aware_output, 'w', encoding='utf-8')
json.dump(output_json, f)
f.close()

test_data_aware_all.loc[:,'label'] = (test_data_aware_all['p(Hallucination)']>=0.5).astype(int)
path_val_model_aware_output = "test.model-aware.json" 
output_json = []
for i in np.arange(test_data_aware_all.shape[0]):
    output_label = 'Hallucination' if test_data_aware_all.loc[i,'label'] == 1 else 'Not Hallucination'
    prob=test_data_aware_all.loc[i,'p(Hallucination)']
    id=test_data_aware_all.loc[i,'id']
    item_to_json = {"label":output_label, "p(Hallucination)":np.float64(prob), "id":int(id)}
    output_json.append(item_to_json)
f = open(path_val_model_aware_output, 'w', encoding='utf-8')
json.dump(output_json, f)
f.close()