import os
import re
import sys
import time
import json
import requests
import openai
from dotenv import load_dotenv

sys.path.insert(0, '../')
from negotiation_game.Agent import Seller

DEAL_PROMPT = "Tell me if this pair of conversation turns indicates if a deal has been accepted. Just respond with one word, yes or no:\n\n"
PRICE_PROMPT = "What price did the buyer and seller agree on? Just give the price.\n\n"

# Set up OpenAI API Key
load_dotenv()
openai.organization = os.getenv("API_ORG_KEY")
openai.api_key = os.getenv("API_KEY")

with open('../prompts.json') as f:
    prompts = json.load(f)

with open('convo.txt') as f:
    convo = f.readlines()

with open('feedback.txt') as f:
    feedback = f.read()

buyer_prompt = prompts['buyer_prompt']['instructional_prompt']

def format_hist(hist):
    new_hist = [{'role': 'system', 'content': buyer_prompt}]
    for msg in hist[1:]:
        role = 'assistant' if msg['role'] == 'user' else 'user'
        new_hist.append({'role': role, 'content': msg['content'].split(' \n ')[0] if '\n' in msg['content'] else msg['content']})
    return new_hist

def vicuna_bot(history, user_text, parameters={}, unit=None, url = None):
    data={"user_text": user_text, 'history': history, 'parameters': parameters, 'unit': unit}
    data = json.dumps(data)

    result = requests.post(url=url,
                        data=data,
                        headers={'content-type': 'application/json'}).json()
    
    return dict(history=result['history'], response=result['response'], params=result['parameters'])

def join_hist(hist):
    convo = ''
    for i, row in enumerate(hist):
        if i % 2 == 0:
            convo += 'SELLER: ' + row + '\n'
        else:
            convo += 'BUYER: ' + row + '\n'
    return convo

def chatgpt_chatbot(messages, model = 'gpt-4'):
    # print(messages)
    while True:
        try:
            response = openai.ChatCompletion.create(
                model=model,
                # model="gpt-4",
                # model = "gpt-3.5-turbo-0301",
                messages=messages,
                request_timeout = 35
            )
            break
        except Exception as E:
            print(f'api call fail{E}')
            time.sleep(3)
        # print(response)
    return response["choices"][0]["message"]["content"].strip()

def alphazero_sim():
    seller = Seller()
    deal_amounts = []
    # complete_hist = []
    for j in range(100):
        # Start the conversation
        history = []
        params = dict()
        user_text = seller.prompts['system_prompts']['instructional_prompt']
        output = seller.get_response(user_text, history, params)
        history = output['history']
        print(f"Bot: {output['response']}")

        convo_hist = [output['response']]
        i = 0
        while True:
            if i >= 6:
                break

            while True:
                try:
                    user_text = chatgpt_chatbot(format_hist(history))
                    break
                except:
                    print('gpt-4 fail')
                    time.sleep(5)
            
            user_text = user_text.replace('\n', ' ')
            convo_hist.append(user_text)
            print()
            print(f"Buyer: {user_text}")
            print()
            if user_text == "quit":
                break
            output = seller.get_response(user_text, history, params)
            history = output['history']
            params = output['parameters']
            convo_hist.append(output['response'])
            print(f"Bot: {output['response']}\n")
            i += 1

            if len(convo_hist) >= 2:
                while True:
                    try:
                        chatgpt_resp = chatgpt_chatbot([{'role': 'user', 
                                                    'content': DEAL_PROMPT + 'PERSON1: ' + convo_hist[-2] + '\n' +
                                                    'PERSON2: ' + convo_hist[-1]}]).lower()
                        break
                    except:
                        print('gpt-4 fail')
                        time.sleep(3)
                        
                # print(chatgpt_resp)
                # print(params['state'])
                if 'yes' in chatgpt_resp:
                    deal_amount = chatgpt_chatbot([{'role': 'user', 'content': PRICE_PROMPT + join_hist(convo_hist)}])
                    try:
                        int(re.sub("[^0-9]", "", deal_amount))
                    except:
                        deal_amount = 0
                    print('--------------------------------------------------------\nDeal Reached')
                    print('Amount: ' + deal_amount)
                    deal_amounts.append(deal_amount)
                    break
        
    with open('deals.txt', 'w') as fp:
        for item in deal_amounts:
            # write each item on a new line
            fp.write("%s\n" % item)

def gpt4_sim():
    deal_amounts = []
    for j in range(10):
        # Start the conversation
        history = []
        params = dict()
        history.append({'role': 'system', 'content': prompts['system_prompts']['instructional_prompt']})
        output = chatgpt_chatbot(history + [{'role': 'user', 'content': 'Begin the negotiation as the seller.'}], 'gpt-3.5-turbo-0301')
        output.replace('\n', ' ')
        history.append({'role': 'assistant', 'content': output})
        # print(f"Bot: {output}")

        convo_hist = [output]
        i = 0
        while True:
            if i >= 10:
                break
            user_text = chatgpt_chatbot(format_hist(history))
            user_text = user_text.replace('\n', ' ')
            convo_hist.append(user_text)
            history.append({'role': 'user', 'content': user_text})
            # print()
            # print(f"Buyer: {user_text}")
            # print()
            if user_text == "quit":
                break
            output = chatgpt_chatbot(history, 'gpt-3.5-turbo-0301')
            output = output.replace('\n', ' ')
            history.append({'role': 'assistant', 'content': output})
            convo_hist.append(output)
            # print(f"Bot: {output}\n")
            i += 1

            if len(convo_hist) >= 2:
                try:
                    chatgpt_resp = chatgpt_chatbot([{'role': 'user', 
                                                'content': DEAL_PROMPT + 'PERSON1: ' + convo_hist[-2] + '\n' +
                                                'PERSON2: ' + convo_hist[-1]}]).lower()
                except:
                    chatgpt_fail = True
                    time.sleep(20)
                    print('chatgpt_fail')
                    break
                # print(chatgpt_resp)
                # print(params['state'])
                if 'yes' in chatgpt_resp:
                    deal_amount = chatgpt_chatbot([{'role': 'user', 'content': PRICE_PROMPT + join_hist(convo_hist)}])
                    try:
                        int(re.sub("[^0-9]", "", deal_amount))
                    except:
                        deal_amount = 0
                    print('--------------------------------------------------------\nDeal Reached')
                    print('Amount: ' + str(deal_amount))
                    deal_amounts.append(deal_amount)
                    break
        
    with open('deals.txt', 'w') as fp:
        for item in deal_amounts:
            # write each item on a new line
            fp.write("%s\n" % item)

def self_play_sim():
    deal_amounts = []
    for j in range(100):
        # Start the conversation
        history = []
        seller_history = []
        
        seller_history.append({'role': 'system', 'content': prompts['system_prompts']['instructional_prompt']})
        seller_history.append({'role': 'user', 'content': 'Begin the negotiation as the seller.'})

        for i, txt in enumerate(convo):
            role = 'user'
            if i % 2 == 0:
                role = 'assistant'
            seller_history.append({'role': role, 'content': txt})
        
        seller_history.append({'role': 'user', 'content': feedback})
        seller_history.append({'role': 'assistant', 'content': 'Thank you for the feedback. I will incorporate this into the next negotation.'})
        seller_history.append({'role': 'user', 'content': 'Begin the next negotiation as the seller.'})
        

        history.append({'role': 'system', 'content': prompts['system_prompts']['instructional_prompt']})
        history.append({'role': 'user', 'content': 'Begin the negotiation as the seller.'})
        output = chatgpt_chatbot(seller_history)
        output = output.replace('\n', ' ')
        history.append({'role': 'assistant', 'content': output})
        seller_history.append({'role': 'assistant', 'content': output})
        # print(f"Bot: {output}")

        convo_hist = [output]
        i = 0
        while True:
            if i >= 10:
                break
            user_text = chatgpt_chatbot(format_hist(history))
            user_text = user_text.replace('\n', ' ')
            convo_hist.append(user_text)
            history.append({'role': 'user', 'content': user_text})
            seller_history.append({'role': 'user', 'content': user_text})
            # print()
            # print(f"Buyer: {user_text}")
            # print()
            if user_text == "quit":
                break
            output = chatgpt_chatbot(seller_history)
            output = output.replace('\n', ' ')
            history.append({'role': 'assistant', 'content': output})
            seller_history.append({'role': 'assistant', 'content': output})
            convo_hist.append(output)
            # print(f"Bot: {output}\n")
            i += 1

            if len(convo_hist) >= 2:
                try:
                    chatgpt_resp = chatgpt_chatbot([{'role': 'user', 
                                                'content': DEAL_PROMPT + 'PERSON1: ' + convo_hist[-2] + '\n' +
                                                'PERSON2: ' + convo_hist[-1]}]).lower()
                except:
                    chatgpt_fail = True
                    time.sleep(20)
                    print('chatgpt_fail')
                    break
                # print(chatgpt_resp)
                # print(params['state'])
                if 'yes' in chatgpt_resp:
                    deal_amount = chatgpt_chatbot([{'role': 'user', 'content': PRICE_PROMPT + join_hist(convo_hist)}])
                    try:
                        int(re.sub("[^0-9]", "", deal_amount))
                    except:
                        deal_amount = 0
                    print('--------------------------------------------------------\nDeal Reached')
                    print('Amount: ' + deal_amount)
                    deal_amounts.append(deal_amount)
                    break
        
    with open('deals.txt', 'w') as fp:
        for item in deal_amounts:
            # write each item on a new line
            fp.write("%s\n" % item)

def vicuna_sim():
    deal_amounts = []
    for j in range(10):
        # Start the conversation
        history = []
        params = dict()
        history.append({'role': 'bot', 'content': prompts['system_prompts']['instructional_prompt']})
        output = vicuna_bot(history, '[START]')
        # print(f"Bot: {output['response']}")

        convo_hist = [output['response']]
        i = 0
        while True:
            if i >= 10:
                break
            user_text = chatgpt_chatbot(format_hist(history))
            user_text = user_text.replace('\n', ' ')
            convo_hist.append(user_text)
            history.append({'role': 'user', 'content': user_text})
            # print()
            # print(f"Buyer: {user_text}")
            # print()
            if user_text == "quit":
                break
            output = vicuna_bot(output['history'], user_text, output['params'])
            history = output['history']
            convo_hist.append(output['response'])
            # print(f"Bot: {output['response']}\n")
            i += 1

            if len(convo_hist) >= 2:
                try:
                    chatgpt_resp = chatgpt_chatbot([{'role': 'user', 
                                                'content': DEAL_PROMPT + 'PERSON1: ' + convo_hist[-2] + '\n' +
                                                'PERSON2: ' + convo_hist[-1]}]).lower()
                except:
                    chatgpt_fail = True
                    time.sleep(20)
                    print('chatgpt_fail')
                    break
                # print(chatgpt_resp)
                # print(params['state'])
                if 'yes' in chatgpt_resp:
                    deal_amount = chatgpt_chatbot([{'role': 'user', 'content': PRICE_PROMPT + join_hist(convo_hist)}])
                    try:
                        deal_amount = int(re.sub("[^0-9]", "", deal_amount))
                    except:
                        deal_amount = "0"
                    # if int(deal_amount) > 13500:
                    print(convo_hist)
                    print('--------------------------------------------------------\nDeal Reached')
                    print('Amount: ' + str(deal_amount))
                    deal_amounts.append(deal_amount)
                    break
        
    with open('deals.txt', 'w') as fp:
        for item in deal_amounts:
            # write each item on a new line
            fp.write("%s\n" % item)

if __name__ == "__main__":
    # alphazero_sim()
    gpt4_sim()
    # vicuna_sim()
    # self_play_sim()