from tqdm import tqdm
from prompt_template_class import GroupingGenerator
from langchain import LLMChain
from langchain.chat_models import ChatOpenAI
from langchain.llms import OpenAI
from api_key import *
from langchain.prompts.chat import SystemMessagePromptTemplate, ChatPromptTemplate
from output_parser import GroupingOutputParser
from data_creator import GroupingDataCreator
import argparse
from utlis import str2bool
import random
import numpy as np
from langchain.prompts import PromptTemplate
from utlis import load_llama, get_prompt, B_INST, E_INST

parser = argparse.ArgumentParser()
parser.add_argument("--num_examples", type=int, default=200)
parser.add_argument("--model_name", type=str, default="text-davinci-003")
parser.add_argument("--few_shot", type=str2bool, default=True)
parser.add_argument("--cot", type=str2bool, default=False)
parser.add_argument("--multiple_run", type=str2bool, default=True)
args = parser.parse_args()
print(args)
#0.91 0.26 False False
#0.901 0.2 True False
#0.7 0.0 True True
# Parameters setting
num_polygons = 30  # Generate more polygons
num_rules = 15
sides_options = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
colors_options = ['red', 'blue', "while", "black", "yellow", "purple", "gray", "cyan", "brown", "indigo"]
materials_options = ['metal', 'plastic', "glass", "sliver", "gold", "copper", "bronze", "diamond", "jade"]
if "gpt-3.5" in args.model_name or "gpt-4" in args.model_name:
    llm = ChatOpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
elif "llama" in args.model_name:
    args.model_name = "meta-llama/Llama-2-13b-chat-hf"
    llm = load_llama(args.model_name)
else:
    llm = OpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
output_parser = GroupingOutputParser()
prompt_generator = GroupingGenerator()
meta_average_acc = []
meta_full_acc = []
seed_list = [714, 123] if args.multiple_run == True else [714]

for seed in seed_list:
    random.seed(seed)
# Generate polygons and groups
    grouping_creator = GroupingDataCreator(num_polygons, num_rules, sides_options, colors_options, materials_options)
    few_shot_polygons = []
    few_shot_groups = []
    few_shot_selected_rules = []
    for _ in tqdm(range(1)):
        polygons, groups, selected_rules = grouping_creator.create()
        few_shot_polygons.append(polygons)
        few_shot_groups.append(groups)
        few_shot_selected_rules.append(selected_rules)
    acc_list = []
    num_exampels = args.num_examples
    full_correct_count = 0
    all_prompt = prompt_generator.grouping_induction(few_shot_polygons, few_shot_groups, few_shot_selected_rules,
                                                     chain_of_thought=args.cot,
                                                     few_shot=args.few_shot)
    chat_prompt = ChatPromptTemplate.from_messages(all_prompt)
    if "gpt" in args.model_name or "davinci" in args.model_name:
        chain = LLMChain(llm=llm, prompt=chat_prompt)
    else:
        system = ""
        sides_text = str(sides_options).rstrip("]").lstrip("[")
        materials_text = str(materials_options).rstrip("]").lstrip("[")
        colors_text = str(colors_options).rstrip("]").lstrip("[")
        system += chat_prompt.messages[0].format(Colors=colors_text, Materials=materials_text,
                                                 SidesNumber=sides_text).content
        instruction = ""
        example_idx = 0
        if len(chat_prompt.messages) > 2:
            for message in chat_prompt.messages[1:-1]:
                if message.additional_kwargs["name"] == "example_user":
                    if example_idx == 0:
                        instruction += message.format().content + " " + E_INST + " "
                    else:
                        instruction += "<s>" + B_INST + " " +message.format().content + " " +E_INST + " "
                    example_idx += 1
                elif message.additional_kwargs["name"] == "example_assistant":
                    instruction += message.format().content + " " + "</s>\\"+ "\n"
        system += "Additionally, please just output the answer with provided format and don't add any other explanation."
        instruction += chat_prompt.messages[-1].format(Polygons="{Polygons}",
                                                       GroupingResult="{GroupingResult}"
                                                       ).content
        template = get_prompt(instruction, system)
        prompt = PromptTemplate(template=template, input_variables=["Polygons", "GroupingResult"])
        chain = LLMChain(prompt=prompt, llm=llm)
    for _ in tqdm(range(num_exampels)):  # Adjust the range for your needs
        polygons, groups, selected_rules = grouping_creator.create()
        polygons_text, sides, materials, colors, results_text, rules = prompt_generator.generate_grouping_results(polygons, sides_options,
                                                                                                           colors_options, materials_options, groups)

        if "gpt" in args.model_name or "davinci" in args.model_name:
            output = chain.run(Polygons=polygons_text, SidesNumber=sides, Colors=colors, Materials=materials, GroupingResult=results_text)
        else:
            output = chain.run(Polygons=polygons_text, GroupingResult=results_text)
        print(output)
        rules_list = output_parser.parse_inducting(output)
        rules_list = sorted(rules_list)
        gold_rules = sorted(list(groups.keys()))
        partial_correct = 0
        for pred in list(set(rules_list)):
            if pred in gold_rules:
                partial_correct += 1
        if partial_correct == len(gold_rules):
            full_correct_count += 1
        acc_list.append([partial_correct/len(gold_rules), rules_list, gold_rules])
    print(f"Average Accuracy: {sum([x[0] for x in acc_list])/len(acc_list)}")
    print(f"Full Accuracy: {full_correct_count/len(acc_list)}")
    print(f"---------------")
    meta_average_acc.append(sum([x[0] for x in acc_list])/len(acc_list))
    meta_full_acc.append(full_correct_count/len(acc_list))
for idx, average_acc, full_acc in zip(seed_list, meta_average_acc, meta_full_acc):
    print(f"Explanation Accuracy: {average_acc}")
    print(f"Full Explanation Accuracy: {full_acc}")
    print(f"------Seed {idx}------")
print("Meta Average Accuracy: ", sum(meta_average_acc)/len(meta_average_acc))
print("STD of Meta Average Accuracy: ", np.std(meta_average_acc))
print("Meta Full Accuracy: ", sum(meta_full_acc)/len(meta_full_acc))
print("STD of Meta Full Accuracy: ", np.std(meta_full_acc))



