import os
import re
import time

import numpy as np

from .openai_utils import chatgpt_chatbot_price_extraction, join_hist

GET_BUYER_OFFER = """
#INSTRUCTION
You have to extact priced offers from messages. Just give the dollar amount and nothing else. 
If no offer was proposed yet then say so. If an offer was accepted then say so. If the offer
is presented as range of prices, then give both the prices. Do not ellicitate your reasoning. 

#EXAMPLES
Message : "I will be willing to pay something from 10k to 11k" 
Offer:  "10000 to 11000".

Message: "so i am uh looking for this car and my current price range is between uh eleven thousand and five hundred to twelve thousand dollars"
Offer: "11500 to 12000" 

Message: "Ooh, that's kind of rough. Our sticker price for this car is closer to $14,000."
Offer: "14000"

Message: "Yes 12000 sounds like a good price for me."
Offer: "Accepted."

Message: "That's well beyond my price, I can't do that"
Offer: "Refused."

Message: "Sure. No Problem"
Offer: "No offer."

Message: "I don't think I am able to do that"
Offer: "Refused."

Message: "12,500... I mean, could we call it even $13,000?
Offer: "13000"

Message: "You said you would be willing to pay 12k ?"
Offer: "Rephrasing."

#EXTRACTION

Message: {}
Offer: """


def detected_offer_chatgpt(message, history, nb_offers=0, delusional_offer=100):
    response = chatgpt_chatbot_price_extraction(
        messages=[
            {"role": "system", "content": GET_BUYER_OFFER.format(join_hist([message]))}
        ]
    )
    offer = re.sub(",", ".", response)
    nbs = re.sub("[^0-9 ]", "", offer).split()
    nbs = [float(x) for x in nbs]

    if len(nbs) > 0:
        if nb_offers == 0:
            amount = np.min(nbs)
        else:
            amount = np.max(nbs)
    else:
        amount = None

    if amount is not None and amount < delusional_offer:
        amount *= 1000
    if amount is not None:
        return amount
    else:
        return -1
