export CUDA_VISIBLE_DEVICES=0

# L1: Arabic,     Speaker: ABA/   SKA/   YBAA/  ZHAA/
# L1: Mandarin,   Speaker: BWC/   LXC/   NCC/   TXHC/
# L1: Hindi,      Speaker: ASI/   RRBI/  SVBI/  TNI/ 
# L1: Korean,     Speaker: HJK/   HKK/   YDCK/  YKWK/
# L1: Spanish,    Speaker: EBVS/  ERMS/  MBMPS/ NJS/
# L1: Vietnamese, Speaker: HQTV/  PNV/   THV/   TLV/                

dataset_dir=/path/to/l2_arctic/
model_dir=facebook/wav2vec2-base-960h
speaker_list="ASI RRBI SVBI TNI"
l1=hindi


for speaker in $speaker_list; do
        python main_tent.py --asr $model_dir \
                --steps 10 \
                --dataset_name l2arctic \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_l2/exps_l1_$l1/exps_tent_$speaker \
                --lr 2e-4 \
                --extra_noise 0 


        python main_sar.py --asr $model_dir \
                --steps 10 \
                --dataset_name l2arctic \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_l2/exps_l1_$l1/exps_sar_$speaker \
                --lr 2e-4 \
                --extra_noise 0 


        python main_teco.py --asr $model_dir \
                --steps 10 \
                --dataset_name l2arctic \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_l2/exps_l1_$l1/exps_teco_$speaker \
                --lr 2e-4 \
                --extra_noise 0 


        python main_suta.py --asr $model_dir \
                --steps 10 \
                --dataset_name l2arctic \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 0.3 \
                --reweight \
                --log_dir exps_l2/exps_l1_$l1/exps_suta_$speaker \
                --lr 2e-4 \
                --extra_noise 0 


        python main_cea.py --asr $model_dir \
            --steps 20 \
            --dataset_name l2arctic \
            --dataset_dir $dataset_dir \
            --temp 2.5 \
            --episodic \
            --em_coef 0.3 \
            --reweight \
            --log_dir exps_l2/exps_l1_$l1/exps_cea_$speaker \
            --lr 2e-5 \
            --lr2 2e-4 \
            --non_blank \
            --train_feature \
            --extra_noise 0      
done
