theory question_63_3
imports Main

begin

typedecl entity
typedecl event

consts
  Trilobite :: "entity ⇒ bool"
  ExtinctSeaAnimal :: "entity ⇒ bool"
  WaterAnimal :: "entity ⇒ bool"
  Place :: "entity ⇒ bool"
  UnitedStatesOfAmerica :: "entity ⇒ bool"
  Part :: "entity ⇒ entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  ExtinctWaterAnimal :: "entity ⇒ bool"
  FoundIn :: "entity ⇒ entity ⇒ bool"
  CoveredByWater :: "event ⇒ entity ⇒ bool"
  Past :: "event ⇒ bool"

(* Explanation 2: ∀x [Trilobite(x) ⟶ (ExtinctSeaAnimal(x) ∧ WaterAnimal(x))] *)
axiomatization where
  explanation_2: "∀x. Trilobite x ⟶ (ExtinctSeaAnimal x ∧ WaterAnimal x)"

(* Explanation 3: Ohio(l) ∧ Place(l) ∧ ∃y [UnitedStatesOfAmerica(y) ∧ Part(l, y)] *)
axiomatization where
  explanation_3: "Ohio l ∧ Place l ∧ (∃y. UnitedStatesOfAmerica y ∧ Part l y)"

(* Explanation 4: ∀x y. Fossils(x) ∧ ExtinctWaterAnimal(x) ∧ FoundIn(x, y) ⟶ CoveredByWater y Past */)
axiomatization where
  explanation_4: "∀x y. Fossils x ∧ ExtinctWaterAnimal x ∧ FoundIn x y ⟶ CoveredByWater (Past y)"

theorem hypothesis:
  (* Premise: ∃x [Fossils(x) ∧ ExtinctSeaAnimal(x) ∧ Trilobite(x) ∧ FoundIn(x, Ohio)] *)
  assumes asm: "Fossils x ∧ ExtinctSeaAnimal x ∧ Trilobite x ∧ FoundIn x l"
  (* Hypothesis: Ohio(l) was once covered by water(w). *)
  shows "Ohio l ∧ Place l ∧ CoveredByWater l Past"
proof -
  from asm have "Trilobite x" by simp
  then have "ExtinctSeaAnimal x" using explanation_2 by blast
  have "Fossils x ∧ ExtinctWaterAnimal x ∧ FoundIn x l" using asm by simp
  then have "CoveredByWater (Past l)" using explanation_4 by blast
  have "Place l" using explanation_3 by blast
  show ?thesis using `l` `Place l` `CoveredByWater (Past l)` by blast
qed

end
