theory question_11_7
imports Main

begin

typedecl entity
typedecl event

consts
  Appliances :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  SameCircuit :: "entity ⇒ event ⇒ bool"
  Plugging :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Safe :: "event ⇒ bool"

(* Explanation: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
axiomatization where
  explanation: "∀x y z e. Appliances(x) ∧ Many(y) ∧ Outlet(z) ∧ Plugging(e) ∧ Agent(e, x) ∧ Patient(e, z) ⟶ ¬Safe(e)"

theorem hypothesis:
  assumes asm: "Appliances x ∧ Many y ∧ Outlet z ∧ Plugging e ∧ Agent e x ∧ Patient e z"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬Safe e"
proof -
  from asm have danger: "Appliances x ∧ Many y ∧ Outlet z ∧ Plugging e ∧ Agent e x ∧ Patient e z" by simp
  then have unsafe: "¬Safe e" using explanation by blast
  then show ?thesis using unsafe by simp
qed

end
