theory question_52_4
imports Main

begin

typedecl entity
typedecl event

consts
  AdultSponges :: "entity ⇒ bool"
  Gametes :: "entity ⇒ bool"
  Eggs :: "entity ⇒ bool"
  Sperm :: "entity ⇒ bool"
  Produce :: "entity ⇒ entity ⇒ bool"
  Cells :: "entity ⇒ bool"
  Reproduction :: "entity ⇒ entity ⇒ entity ⇒ bool"

(* Explanation: eggs and sperm are both types of gametes. *)
axiomatization where
  explanation: "∀x. Eggs x ⟹ Gametes x" "∀x. Sperm x ⟹ Gametes x"

theorem hypothesis:
  assumes asm: "AdultSponges x"
  (* Hypothesis: Adult sponges produce gametes. *)
  shows "∃y. Gametes y ∧ Produce x y"
proof -
  from asm have "∃g. Gametes g ∧ Reproduction x g" using explanation_1 by blast
  then obtain g where g: "Gametes g ∧ Reproduction x g" by auto
  then have "Produce x g" using Reproduction_def by auto
  show ?thesis using g by blast
qed

end
