theory question_27_6

imports Main

begin

typedecl entity
typedecl event

consts
  WaterVapor :: "entity ⇒ bool"
  Chilling :: "event ⇒ entity ⇒ bool"
  Condense :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Event :: "event ⇒ bool"
  Time :: "event ⇒ event ⇒ bool"

theorem hypothesis:
  assumes asm: "WaterVapor x ∧ Chilling e x"
  (* Hypothesis: Water vapor chilling causes water vapor to condense. *)
  shows "∃z. Condense z x ∧ Patient z x ∧ Event z ∧ Time z e"
proof -
  from asm have "WaterVapor x" "Chilling e x" by simp
  then have "WaterVapor x" "Chilling e x" "Event z" "Condense z x" "Patient z x" "Time z e" if "Condense z x ∧ Patient z x ∧ Event z ∧ Time z e" for z using that by blast
  then show "∃z. Condense z x ∧ Patient z x ∧ Event z ∧ Time z e" using asm by blast
qed

end
