theory question_6_0
imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Tumble :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Spectators :: "entity ⇒ bool"
  Watch :: "event ⇒ bool"
  Experiencer :: "event ⇒ entity ⇒ bool"
  UniversityOfMichigan :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A man tumbles as spectators watch is the same as spectators watch a man tumble. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ Tumble e ∧ Agent e x ⟷ ∃z e. Spectators z ∧ Watch e ∧ Experiencer e z"

theorem hypothesis:
  (* Premise: A man tumbles as spectators watch at the University of Michigan. *)
  assumes asm: "Man x ∧ Tumble e ∧ Agent e x ∧ Spectators z ∧ Watch e ∧ Experiencer e z ∧ UniversityOfMichigan y ∧ In z y"
  (* Hypothesis: Spectators watch a man tumble. *)
  shows "∃x e. Man x ∧ Tumble e ∧ Agent e x ∧ Spectators z ∧ Watch e ∧ Experiencer e z"
proof -
  have "Man x ∧ Tumble e ∧ Agent e x ∧ Spectators z ∧ Watch e ∧ Experiencer e z" using asm by blast
  then show ?thesis using explanation_1 by blast
qed

end
