theory question_49_0
imports Main

begin

typedecl entity
typedecl event

consts
  Group :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Member :: "entity ⇒ entity ⇒ bool"
  Wearing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Costume :: "entity ⇒ bool"

(* Explanation 1: A group means that there are people. *)
axiomatization where
  explanation_1: "∀x. Group x ⟶ (∃y. Person y ∧ Member y x)"

theorem hypothesis:
  (* Premise: A group of people are wearing costumes. *)
  assumes asm: "Group x ∧ Person y ∧ Member y x ∧ Wearing e ∧ Agent e y ∧ Costume  Patient e "
  (* Hypothesis: People are wearing costumes. *)
  shows "∃x e. Person x ∧ Wearing e ∧ Agent e x ∧ Costume  Patient e "
proof -
  from asm have "Group x ∧ Person y ∧ Member y x ∧ Wearing e ∧ Agent e y ∧ Costume (Patient e)" by blast
  then have "Person y ∧ Wearing e ∧ Agent e y ∧ Costume (Patient e)" by simp
  then show ?thesis using asm by blast
qed

end
