theory question_40_9

imports Main

begin

typedecl entity
typedecl event

consts
  Weathering :: "event ⇒ bool"
  Boulder :: "entity ⇒ bool"
  Cracks :: "entity ⇒ bool"
  Forming :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Caused :: "event ⇒ event ⇒ bool"

(* Explanation 1: Weathering causes cracks to form in entities that are boulders. *)
axiomatization where
  explanation_1: "∀x e1 e2. Weathering e2 ∧ Boulder x ⟶ (∃e1. Cracks x ∧ Forming e1 ∧ Agent e1 x ∧ Caused e2 e1)"

theorem hypothesis:
  assumes asm: "Cracks x ∧ Boulder x ∧ Forming e1 ∧ Agent e1 x"
  (* Hypothesis: Cracks forming in a boulder can be caused by weathering. *)
  shows "∃e2. Weathering e2 ∧ Caused e2 e1"
proof -
  from asm have "Cracks x ∧ Boulder x ∧ Forming e1 ∧ Agent e1 x" by simp
  then obtain e2 where e2: "Weathering e2 ∧ Caused e2 e1" using explanation_1 by blast
  show ?thesis using e2 by simp
qed

end
