theory question_1_0

imports Main

begin

typedecl entity
typedecl event

consts
  Hypothesis :: "entity ⇒ bool"
  ScientificGuess :: "entity ⇒ bool"
  CauseAndEffect :: "event ⇒ bool"
  About :: "entity ⇒ event ⇒ bool"

(* Explanation 1: hypothesis means scientific guess about the cause and effect of an event. *)
axiomatization where
  explanation_1: "∀x. Hypothesis x ⟷ (ScientificGuess x ∧ (∃e. CauseAndEffect e ∧ About x e))"

theorem hypothesis:
  assumes asm: "ScientificGuess x"
  (* Hypothesis: The given entity is a scientific guess about the cause and effect of some event. *)
  shows "Hypothesis x"
proof -
  from asm have "ScientificGuess x" by simp
  then have "∃e. CauseAndEffect e ∧ About x e" using explanation_1 by blast
  then show ?thesis by blast
qed

end
