theory question_99_1

imports Main

begin
typedecl entity
typedecl event

consts
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Dog :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"

(* Explanation 1: Running on an entity implies being on that entity. *)
axiomatization where
  explanation_1: "∀x y e. Running e ∧ Agent e x ∧ Patient e y ⟶ On x y"

(* Explanation 2: A dog is an entity. *)
axiomatization where
  explanation_2: "∀x. Dog x ⟶ Entity x"

(* Explanation 3: Grass is an entity. *)
axiomatization where
  explanation_3: "∀x. Grass x ⟶ Entity x"

theorem hypothesis:
  (* Premise: A dog is running on the grass. *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x y. Dog x ∧ Grass y ∧ On x y"
proof -
  {
    assume "Running e ∧ Agent e x ∧ Patient e y"
    from this have "On x y" using explanation_1 by blast
  }
  from asm have "Dog x" by blast
  from asm have "Grass y" by blast
  from asm have "Running e ∧ Agent e x ∧ Patient e y" by blast
  with ‹On x y› have "Dog x ∧ Grass y ∧ On x y" by blast
  then show ?thesis using asm by blast
qed

end
