theory question_75_3
imports Main

begin

typedecl entity
typedecl event

consts
  Marble :: "entity ⇒ bool"
  MetamorphicRock :: "entity ⇒ bool"
  Forms :: "event ⇒ entity ⇒ bool"
  HighPressure :: "event ⇒ bool"
  Heat :: "event ⇒ bool"

(* Explanation 2: Marble is a specific type of metamorphic rock that forms under high pressure and heat conditions, and it is the result of a transformation process from rock to metamorphic rock. *)
axiomatization where
  explanation_2: "∀x y. Marble x ∧ MetamorphicRock y ∧ Forms x y ∧ HighPressure y ∧ Heat y"

(* Hypothesis sentence: Extreme heat and pressure change rock into marble. *)
hypothesis:
  assumes asm: "ExtremeHeat x ∧ Pressure y ∧ Rock z"
  shows "∃e. Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ∧ Marble z"
proof -
  from asm have "ExtremeHeat x ∧ Pressure y ∧ Rock z" by simp
  then obtain e1 where e1: "Change e1 ∧ Agent e1 x ∧ Agent e1 y ∧ Patient e1 z" using explanation_1 by blast
  then have "MetamorphicRock z" using explanation_2 by blast
  have conclusion: "Change e1 ∧ Agent e1 x ∧ Agent e1 y ∧ Patient e1 z" using e1 by simp
  show ?thesis using asm conclusion `MetamorphicRock z` by blast
qed

end
