theory question_98_5

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Causes :: "event ⇒ event ⇒ bool"

(* Explanation 1: The young man's jumping out of the pool is causing water to splash everywhere. *)
axiomatization where
  explanation_1: "∃x y e1 e2. YoungMan x ∧ Pool y ∧ Jumping e1 ∧ Splashing e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Causes e1 e2"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x  ∧ Goggles z  ∧ Pool y  ∧ Jumping e1  ∧ Splashing e2  ∧ Agent e1  x  ∧ Patient e1  y  ∧ In e1  z  ∧ Causes e1  e2 "
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x  ∧ Jumping e  ∧ Agent e  x "
proof -
  from asm have "YoungMan x" by blast
  from this have "Man x" using explanation_1 by blast
  from asm have "Pool y" by blast
  show ?thesis using `Man x` `Pool y` by blast
qed

end
