theory question_90_3

imports Main

begin

typedecl entity
typedecl event

consts
 Worker :: "entity ⇒ bool"
 BentOver :: "event ⇒ bool"
 PullingGrass :: "entity ⇒ bool"
 Man :: "entity ⇒ bool"
 Running :: "event ⇒ bool"
 SeenSomethingScary :: "entity ⇒ bool"
 WalkingDownTheStreet :: "entity ⇒ bool"
 Suddenly :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If three workers are bent over, they are pulling grass. *)
axiomatization where
 explanation_1: "∀x y e. Worker x ∧ BentOver e ∧ PullingGrass y ⟶ Agent e x ∧ Patient e y"

(* Explanation 2: If a man is running, he has seen something scary. *)
axiomatization where
 explanation_2: "∀x e. Man x ∧ Running e ⟶ SeenSomethingScary x"

(* Explanation 3: A man who is walking down the street and suddenly starts to run has seen something scary. *)
axiomatization where
 explanation_3: "∃x y z e. Man x ∧ WalkingDownTheStreet y ∧ Suddenly z ∧ Running e ∧ SeenSomethingScary x ∧ Agent e x ∧ In e z"

theorem hypothesis:
 (* Premise: Three workers bent over pulling grass. *)
 assumes asm: "Worker x ∧ BentOver e ∧ PullingGrass y ∧ Agent e x ∧ Patient e y ∧ In e z"
 (* Hypothesis: A man who is walking down the street and suddenly starts to run has seen something scary. *)
 shows "∃x y z e. Man x ∧ WalkingDownTheStreet y ∧ Suddenly z ∧ Running e ∧ SeenSomethingScary x ∧ Agent e x ∧ In e z"
proof -
 from asm have "Worker x ∧ BentOver e ∧ PullingGrass y" by blast
 then have "Agent e x ∧ Patient e y" using explanation_1 by blast
 then show ?thesis using `Man x` `WalkingDownTheStreet y` `Suddenly z` `Running e` `SeenSomethingScary x` by blast
qed

end
