theory question_81_4

imports Main

begin

typedecl entity
typedecl event
consts
  Person :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"

(* Explanation 1: A person exists and is riding a bicycle. *)
axiomatization where
  explanation_1: "∃x e. Person x ∧ Riding e ∧ Agent e x"

(* Explanation 2: The person has a bike. *)
axiomatization where
  explanation_2: "∀x. Person x ⟶ Has x Bike"

(* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
assumes asm: "Person x  ∧ Bicycle y  ∧ Helmet z  ∧ Jumping e  ∧ Agent e  x  ∧ Patient e  y  ∧ InFrontOf x  z  ∧ Skyline z  ∧ Lake z "

(* Hypothesis: A person outside with a bike. *)
shows "∃x y e. Person x  ∧ Outside y  ∧ Bike e  ∧ Riding e  ∧ Agent e  x  ∧ Patient e  y "
proof -
  from asm have "Person x" by blast
  from this have "Outside y" using explanation_1 by blast
  from asm have "Bike e" by blast
  show ?thesis using `Person x` `Outside y` `Bike e` by blast
qed

end
