theory question_27_0

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  DirtySidewalk :: "entity ⇒ bool"
  Outdoors :: "event ⇒ bool"
  Being :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The man is on a dirty sidewalk. Sidewalks are found outdoors, therefore, the man is outside *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ DirtySidewalk y ∧ Outdoors e ∧ Being e x ∧ On e y"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ DirtySidewalk z ∧ Selling e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: The man is outside. *)
  shows "∃x e. Man x ∧ Outside e"
proof -
  from asm have "Man x" by blast
  from this have "Outside e" using explanation_1 by blast
  show ?thesis using `Man x` `Outside e` by blast
qed

end
