theory question_87_5

imports Main

begin

typedecl entity

consts
  Limestone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  Contains :: "entity ⇒ entity ⇒ bool"
  UsefulInStudyingHistoryOfLivingOrganisms :: "entity ⇒ bool"

(* Explanation 1: Limestone is a type of sedimentary rock. *)
axiomatization where
  explanation_1: "∀x. Limestone x ⟶ SedimentaryRock x"

(* Explanation 2: Limestone, which contains fossils, is useful in studying the history of living organisms. *)
axiomatization where
  explanation_2: "∀x y. Limestone x ∧ Fossils y ∧ Contains x y ⟶ UsefulInStudyingHistoryOfLivingOrganisms x"  

theorem hypothesis:
  assumes asm: "Limestone x"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "UsefulInStudyingHistoryOfLivingOrganisms x"
proof -
  from asm have "Limestone x" by simp
  then have "SedimentaryRock x" using explanation_1 by blast
  then obtain y where "Fossils y ∧ Contains x y" using explanation_2 by blast
  then have "UsefulInStudyingHistoryOfLivingOrganisms x" using explanation_2 by blast
  then show ?thesis by simp
qed

end
