theory question_60_5
imports Main
begin
typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  KarateForm :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  Poses :: "event ⇒ bool"
  Showing :: "event ⇒ bool"
  Shows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When a boy poses in karate form and uniform, he is showing his uniform. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Showing e2 ∧ Agent e2 x ∧ Patient e2 z ⟶ Shows e2"

theorem hypothesis:
  (* Premise: A boy poses in karate form and uniform. *)
  assumes asm: "Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ Agent e x ∧ Patient e y"
  shows "∃x y e. Boy x ∧ Uniform y ∧ Shows e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A boy shows "his uniform. *)"
proof -
  from asm have "Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ Agent e x ∧ Patient e y" by blast
  then have "Boy x ∧ Uniform z ∧ Shows e ∧ Agent e x ∧ Patient e z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
